/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import io.agora.mediaplayer.IMediaPlayerCacheManager;
import io.agora.rtc2.internal.RtcEngineImpl;

public class MediaPlayerCacheManagerImpl
implements IMediaPlayerCacheManager {
    protected static MediaPlayerCacheManagerImpl mInstance = null;
    private final RtcEngineImpl mRtcEngineImpl;
    private int cacheManagerInitStatus = -1;

    protected static synchronized IMediaPlayerCacheManager getMediaPlayerCacheManager(RtcEngineImpl rtcEngineImpl) {
        if (rtcEngineImpl == null) {
            return null;
        }
        if (mInstance == null) {
            mInstance = new MediaPlayerCacheManagerImpl(rtcEngineImpl);
        }
        return mInstance;
    }

    protected static synchronized void destroyMediaPlayerCacheManager() {
        mInstance = null;
    }

    private MediaPlayerCacheManagerImpl(RtcEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = rtcEngineImpl;
        this.cacheManagerInitStatus = this.mRtcEngineImpl.initMediaPlayerCacheManager();
    }

    @Override
    public int removeAllCaches() {
        return this.mRtcEngineImpl.mediaPlayerCacheRemoveAllCaches();
    }

    @Override
    public int removeOldCache() {
        return this.mRtcEngineImpl.mediaPlayerCacheRemoveOldCache();
    }

    @Override
    public int removeCacheByUri(String uri) {
        return this.mRtcEngineImpl.mediaPlayerCacheRemoveCacheByUri(uri);
    }

    @Override
    public int setCacheDir(String path) {
        return this.mRtcEngineImpl.mediaPlayerCacheSetCacheDir(path);
    }

    @Override
    public int setMaxCacheFileCount(int count) {
        return this.mRtcEngineImpl.mediaPlayerCacheSetMaxCacheFileCount(count);
    }

    @Override
    public int setMaxCacheFileSize(long cacheSize) {
        return this.mRtcEngineImpl.mediaPlayerCacheSetMaxCacheFileSize(cacheSize);
    }

    @Override
    public int enableAutoRemoveCache(boolean enable) {
        return this.mRtcEngineImpl.mediaPlayerCacheEnableAutoRemoveCache(enable);
    }

    @Override
    public String getCacheDir() {
        return this.mRtcEngineImpl.mediaPlayerCacheGetCacheDir();
    }

    @Override
    public int getMaxCacheFileCount() {
        return this.mRtcEngineImpl.mediaPlayerCacheGetMaxCacheFileCount();
    }

    @Override
    public long getMaxCacheFileSize() {
        return this.mRtcEngineImpl.mediaPlayerCacheGetMaxCacheFileSize();
    }

    @Override
    public int getCacheFileCount() {
        return this.mRtcEngineImpl.mediaPlayerCacheGetCacheFileCount();
    }

    public int getCacheManagerInitStatus() {
        return this.cacheManagerInitStatus;
    }
}

