/*
 * Decompiled with CFR 0.152.
 */
package de.timfreiheit.plugin.resourceplaceholders;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import de.timfreiheit.plugin.resourceplaceholders.ResourcePlaceholdersExtension;
import de.timfreiheit.plugin.resourceplaceholders.ResourcePlaceholdersPlugin;
import de.timfreiheit.plugin.resourceplaceholders.ResourcePlaceholdersTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J(\u0010\f\u001a\u00020\t\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/timfreiheit/plugin/resourceplaceholders/ResourcePlaceholdersPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "config", "Lde/timfreiheit/plugin/resourceplaceholders/ResourcePlaceholdersExtension;", "pluginConfigured", "", "apply", "", "project", "configure", "configureAndroid", "T", "Lcom/android/build/gradle/api/BaseVariant;", "variants", "Lorg/gradle/api/DomainObjectSet;", "getOutputDirForVariant", "Ljava/io/File;", "variant", "searchFilesInSourceSet", "", "sourceSet", "Lcom/android/builder/model/SourceProvider;", "placeholders"})
public final class ResourcePlaceholdersPlugin
implements Plugin<Project> {
    private ResourcePlaceholdersExtension config;
    private boolean pluginConfigured;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = project.getExtensions().create("resourcePlaceholders", ResourcePlaceholdersExtension.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.creat\u2026ersExtension::class.java)");
        this.config = (ResourcePlaceholdersExtension)object;
        project.getPlugins().whenPluginAdded((Action)new Action<Plugin<Object>>(this, project){
            final /* synthetic */ ResourcePlaceholdersPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.afterEvaluate((Action)new Action<Project>(this){
                    final /* synthetic */ apply.1 this$0;

                    public final void execute(Project $noName_0) {
                        ResourcePlaceholdersPlugin.access$configure(this.this$0.this$0, this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = resourcePlaceholdersPlugin;
                this.$project = project;
            }
        });
    }

    private final void configure(Project project) {
        if (this.pluginConfigured) {
            return;
        }
        project.getPlugins().all((Action)new Action<Plugin<Object>>(this, project){
            final /* synthetic */ ResourcePlaceholdersPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                DomainObjectSet variants;
                DomainObjectSet domainObjectSet;
                Object object = it;
                if (object instanceof AppPlugin) {
                    Object object2 = this.$project.getExtensions().getByType(AppExtension.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.extensions.getBy\u2026AppExtension::class.java)");
                    domainObjectSet = ((AppExtension)object2).getApplicationVariants();
                } else if (object instanceof LibraryPlugin) {
                    Object object3 = this.$project.getExtensions().getByType(LibraryExtension.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"project.extensions.getBy\u2026aryExtension::class.java)");
                    domainObjectSet = (DomainObjectSet)((LibraryExtension)object3).getLibraryVariants();
                } else {
                    domainObjectSet = null;
                }
                DomainObjectSet domainObjectSet2 = variants = domainObjectSet;
                if (domainObjectSet2 != null) {
                    object = (Collection)domainObjectSet2;
                    if (!object.isEmpty()) {
                        ResourcePlaceholdersPlugin.access$setPluginConfigured$p(this.this$0, true);
                        ResourcePlaceholdersPlugin.access$configureAndroid(this.this$0, this.$project, variants);
                    }
                }
            }
            {
                this.this$0 = resourcePlaceholdersPlugin;
                this.$project = project;
            }
        });
    }

    private final <T extends BaseVariant> void configureAndroid(Project project, DomainObjectSet<T> variants) {
        Iterable $receiver$iv = (Iterable)variants;
        for (Object element$iv : $receiver$iv) {
            Map map;
            BaseVariant variant = (BaseVariant)element$iv;
            ConfigurableFileCollection configurableFileCollection = project.files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files()");
            FileCollection files = (FileCollection)configurableFileCollection;
            BaseVariant baseVariant = variant;
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"variant");
            List list = baseVariant.getSourceSets();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variant.sourceSets");
            Iterable $receiver$iv2 = list;
            for (Object element$iv2 : $receiver$iv2) {
                SourceProvider sourceSet;
                SourceProvider sourceProvider = sourceSet = (SourceProvider)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceProvider, (String)"sourceSet");
                List<File> collectedFiles = this.searchFilesInSourceSet(sourceProvider);
                ConfigurableFileCollection fileCollection = project.files(new Object[]{collectedFiles});
                FileCollection fileCollection2 = files.plus((FileCollection)fileCollection);
                if (fileCollection2 == null) {
                    ConfigurableFileCollection configurableFileCollection2 = fileCollection;
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"fileCollection");
                    fileCollection2 = (FileCollection)configurableFileCollection2;
                }
                files = fileCollection2;
            }
            File outputDirectory = this.getOutputDirForVariant(project, variant);
            SourceProvider sourceProvider = (SourceProvider)variant.getSourceSets().get(variant.getSourceSets().size() - 1);
            if (!(sourceProvider instanceof AndroidSourceSet)) {
                throw (Throwable)new IllegalStateException("sourceProvider is not an AndroidSourceSet");
            }
            ((AndroidSourceSet)sourceProvider).getRes().srcDir((Object)outputDirectory);
            StringBuilder stringBuilder = new StringBuilder().append("resourcePlaceholdersFor");
            String string = variant.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
            String taskName = stringBuilder.append(StringsKt.capitalize((String)string)).toString();
            Task task = project.getTasks().create(taskName, ResourcePlaceholdersTask.class);
            ResourcePlaceholdersTask $receiver = (ResourcePlaceholdersTask)task;
            $receiver.setSources(files);
            $receiver.setOutputDir(outputDirectory);
            BuildType buildType = variant.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType, (String)"variant.buildType");
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType.getManifestPlaceholders(), (String)"variant.buildType.manifestPlaceholders");
            ProductFlavor productFlavor = variant.getMergedFlavor();
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"variant.mergedFlavor");
            Map map2 = productFlavor.getManifestPlaceholders();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"variant.mergedFlavor.manifestPlaceholders");
            Map map3 = MapsKt.toMutableMap((Map)map2);
            ResourcePlaceholdersTask resourcePlaceholdersTask = $receiver;
            Map $receiver2 = map3;
            $receiver2.put("applicationId", variant.getApplicationId());
            Map map4 = map3;
            resourcePlaceholdersTask.setPlaceholders(MapsKt.plus((Map)map, (Map)MapsKt.toMap((Map)map4)));
            ResourcePlaceholdersTask task2 = (ResourcePlaceholdersTask)task;
            variant.registerGeneratedResFolders((FileCollection)project.files(new Object[]{new File(outputDirectory, "_dummy")}).builtBy(new Object[]{task2}));
        }
    }

    private final List<File> searchFilesInSourceSet(SourceProvider sourceSet) {
        List files = new ArrayList();
        for (File resDirectory : sourceSet.getResDirectories()) {
            ResourcePlaceholdersExtension resourcePlaceholdersExtension = this.config;
            if (resourcePlaceholdersExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            Iterable $receiver$iv = resourcePlaceholdersExtension.getFiles();
            for (Object element$iv : $receiver$iv) {
                String fileName = (String)element$iv;
                File file = new File(resDirectory, fileName);
                if (!file.exists() || file.isDirectory()) continue;
                files.add(file);
            }
        }
        return files;
    }

    private final File getOutputDirForVariant(Project project, BaseVariant variant) {
        StringBuilder stringBuilder = new StringBuilder().append(project.getBuildDir()).append("/generated/res/resourcesPlaceholders/").append(variant.getFlavorName()).append('/');
        BuildType buildType = variant.getBuildType();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildType, (String)"variant.buildType");
        File file = project.file((Object)stringBuilder.append(buildType.getName()).append('/').toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(\"${project.\u2026ariant.buildType.name}/\")");
        return file;
    }

    public static final /* synthetic */ void access$configure(ResourcePlaceholdersPlugin $this, @NotNull Project project) {
        $this.configure(project);
    }

    public static final /* synthetic */ boolean access$getPluginConfigured$p(ResourcePlaceholdersPlugin $this) {
        return $this.pluginConfigured;
    }

    public static final /* synthetic */ void access$setPluginConfigured$p(ResourcePlaceholdersPlugin $this, boolean bl) {
        $this.pluginConfigured = bl;
    }

    public static final /* synthetic */ void access$configureAndroid(ResourcePlaceholdersPlugin $this, @NotNull Project project, @NotNull DomainObjectSet variants) {
        $this.configureAndroid(project, variants);
    }
}

