package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

/**
 * Created by lhf on 2018/8/7.
 * <p>
 * YY.Inc
 */
public class GetToInfoParam {

    public int appId; //分配给业务的appId 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的appId
    public long uid; //用户uid
    public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

    public GetToInfoParam() {
        appId = 0;
        channelId = 0;
        uid = 0;
        sid = 0;
        ssid = 0;
        retry = null;
    }

    public static final class GetToInfoParamBuilder {
        public int appId; //分配给业务的appId 不填或者填0使用默认的appId
        public int channelId; //渠道id 不填或者填0使用默认的appId
        public long uid; //用户uid
        public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
        public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
        public ArrayList<Integer> retry = null; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.
        private GetToInfoParamBuilder() {
        }

        public static GetToInfoParamBuilder aGetToInfoParam() {
            return new GetToInfoParamBuilder();
        }

        public GetToInfoParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public GetToInfoParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public GetToInfoParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public GetToInfoParamBuilder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public GetToInfoParamBuilder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public GetToInfoParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public GetToInfoParam build() {
            GetToInfoParam getToInfoParam = new GetToInfoParam();
            getToInfoParam.appId = this.appId;
            getToInfoParam.channelId = this.channelId;
            getToInfoParam.ssid = this.ssid;
            getToInfoParam.sid = this.sid;
            getToInfoParam.uid = this.uid;
            getToInfoParam.retry = this.retry;
            return getToInfoParam;
        }
    }
}
