package com.yy.mobile.framework.revenuesdk.gift.reporter

import com.yy.mobile.framework.revenuesdk.baseapi.reporter.HiidoReport
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.IReporter
import com.yy.mobile.framework.revenuesdk.gift.BuildConfig

/**
 * Created by nls on 2019/3/19.
 * Describe: Nothing.
 */
class DefaultGiftReporter(
        private val iReporter: IReporter?,
        private val clientVer: String,
        private val country: String
) : IGiftReporter {

    /**
     * 发送礼物给用户结果
     */
    override fun onSendGiftToUserResault(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String =
                        HiidoReport.getInstance().getUri("onSendGiftToUserResault", response)
                it.reportReturnCode(HiidoReport.CReportParam.INTER_SCODE, uri, 0,
                        response.mErrCode.toString())
            }
        }
    }

    /**
     * 发送礼物给多个用户结果（全麦）
     */
    override fun onSendGiftToMultiUserResault(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String =
                        HiidoReport.getInstance().getUri("onSendGiftToMultiUserResault", response)
                it.reportReturnCode(HiidoReport.CReportParam.INTER_SCODE, uri, 0,
                        response.mErrCode.toString())
            }
        }
    }

    /**
     * 获取全部礼物列表
     */
    override fun onLoadAllGiftResault(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String = HiidoReport.getInstance().getUri("onLoadAllGiftResault", response)
                it.reportReturnCode(HiidoReport.CReportParam.INTER_SCODE, uri, 0,
                        response.mErrCode.toString())
            }
        }
    }

    /**
     * 获取用户包裹礼物列表
     */
    override fun onLoadPackageGiftResault(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String =
                        HiidoReport.getInstance().getUri("onLoadPackageGiftResault", response)
                it.reportReturnCode(HiidoReport.CReportParam.INTER_SCODE, uri, 0,
                        response.mErrCode.toString())
            }
        }
    }

    /**
     * 给多人送礼上报（汇总）
     * @param response
     */
    override fun onSendMutilSummaryResult(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String =
                        HiidoReport.getInstance().getSummaryUri("SendGiftMutilUser", response)
                it.reportReturnCode(HiidoReport.CReportParam.SUMMARY_SCODE, uri, 0,
                        response.mErrCode
                                .toString())
            }
        }
    }

    /**
     * 给单人送礼上报（汇总）
     * @param response
     */
    override fun onSendSingleSummaryResult(response: HiidoReport.CReportResponse) {
        iReporter?.let {
            if (HiidoReport.getInstance().isReportByRandomRatio) {
                var map = responseToMap(response)
                it.reportStatisticContent(HiidoReport.CReportParam.ACT, map)
                val uri: String =
                        HiidoReport.getInstance().getSummaryUri("SendGiftSingleUser", response)
                it.reportReturnCode(HiidoReport.CReportParam.SUMMARY_SCODE, uri, 0,
                        response.mErrCode.toString())
            }
        }
    }

    private fun responseToMap(response: HiidoReport.CReportResponse): MutableMap<String, String> {
        var map = mutableMapOf<String, String>()
        map["uid"] = response.mUid.toString()
//        map["paysource"] = response.mPaysource.toString()
        map["code"] = response.mErrCode.toString()
        map["msg"] = response.mErrMsg.toString()
        map["retry"] = "0"
        map["country"] = HiidoReport.CReportResponse.mCountry
        map["clientver"] = clientVer
        map["orderid"] = response.mOrderId
        map["area"] = country
        map["sdkver"] = BuildConfig.VERSION_NAME
        map["eventid"] = response.mEventId
        map["eventaliae"] = response.mEventaliae
        map["delay"] = response.mDelay
        map["gporderid"] = response.mGPOrderId
        map["purchasetime"] = response.mPurchaseTime

        return map
    }

    private fun reportInternal(act: String, map: MutableMap<String, String>) {
    }
}