package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by nls on 2019/6/13.
 * <p>
 * # Request
 * {
 * "cmd":1042,
 * "seq":"$seq",   //
 * "ticket":"$ticket"    // 需验证
 * "uid":$uid,        // 赠送者uid，必填
 * "sid":$sid,        //赠送时频道号，频道外传0
 * "ssid":$ssid,  //赠送时子频道号
 * "appId":$appId,   // 业务id，分配而得，必传
 * "usedChannel":$usedChannel,   // 渠道id，分配而得，必填
 * "ip":$ip,   // ip地址，选传
 * <p>
 * "propsId":$propsId,   // 道具id
 * "count":$count,       // 使用数量
 * "senderUserInfo":{
 * "uid":$uid, //赠送者uid，必填
 * "yyno":$yyno, //赠送者yy号，不传请填0
 * "nickName":$nickName //赠送者昵称，不传请填空串
 * },
 * "recverUserInfos":[
 * {
 * "uid":$uid, //收礼者-A uid，必填
 * "yyno":$yyno, //收礼者-A yy号，不传请填0
 * "nickName":$nickName, //收礼者-A 昵称，不传请填空串
 * "expand":$expand //扩展字段，收礼人相关的信息分别放在这个字段，代码中送礼时会对这个expand和外层expand进行合并
 * },
 * {
 * "uid":$uid, //收礼者-B uid，必填
 * "yyno":$yyno, //收礼者-B yy号，不传请填0
 * "nickName":$nickName, //收礼者-B 昵称，不传请填空串
 * "expand":$expand //扩展字段，收礼人相关的信息分别放在这个字段，代码中送礼时会对这个expand和外层expand进行合并
 * }
 * ],
 * <p>
 * //使用外部账号赠送时，需要使用到以下三个字段
 * "senderExternUid":$senderExternUid,    //赠送者外部uid，选填
 * "senderExternUname":$senderExternUname,    //赠送者外部昵称，选填
 * "senderAccessToken":$senderAccessToken,    //accessToken，选填
 * <p>
 * "expand":"$expand"    // 扩展字段，请求时expand字段原文
 * （根据业务不同，可能传不同的值，如寻欢：{"playType":1}）
 * <p>
 * "payGateOrderId":"$payGateOrderId"   , // 选填
 * "payWay":$payWay ,  //选填，需要指定支付方式时候填写，4-AppleStore 6-ZfbWap 9 WeixinWap
 * "payAdditionInfo":"$payAdditionInfo" //选填，指定了支付方式后，苹果或银行支付需要指定填入信息
 * }
 */

public class SendGiftToMultiUserRequest extends BaseJsonRequest {

    public String seq;
    public long uid;
    public long sid;
    public long ssid;
    public int appId;
    public int usedChannel;
    public int propsId;
    public int count;
    public long senderUid;
    public String sendernickname;
    public String expend;
    public boolean isAutoBuy;
    public String payGateOrderId;
    public String payWay;
    public String payAdditionInfo;
    public String ticket;
    public List<SendGiftParamV2.TargetUser> targetUsers;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        int cmd = ProtocolCmd.ConsumeAndUseMultipleRequest;
        try {
            jMsg.put("cmd", cmd);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);  // data 不需要传递ticket，否则是service协议出错
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("ssid", ssid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("propsId", propsId);
            jMsg.put("count", count);
            //sender
            JSONObject sender = new JSONObject();
            sender.put("uid", senderUid);
            sender.put("yyno", "");
            sender.put("nickName", sendernickname);
            jMsg.put("senderUserInfo", sender);
            JSONArray targetArray = new JSONArray();
            //receiver
            for (int i = 0; i < targetUsers.size(); i++) {
                JSONObject target = new JSONObject();
                target.put("uid", targetUsers.get(i).uid);
                target.put("yyno", targetUsers.get(i).yyNum);
                target.put("nickName", targetUsers.get(i).nickName);
                target.put("expand", targetUsers.get(i).expand);
                targetArray.put(target);
            }
            jMsg.put("recverUserInfos", targetArray);
            jMsg.put("expand", expend);
            jMsg.put("payGateOrderId", payGateOrderId);
            jMsg.put("payWay", payWay);
            jMsg.put("payAdditionInfo", payAdditionInfo);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("SendGiftToMultiUserRequest", "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest = new PSCIMessageRequest(cmd, appId, 0, ticket, "", jsonMsg);
    }
}
