package com.yy.mobile.framework.revenuesdk.gift;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;

import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.GetGiftBagInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadAllGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadPackageGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadReceiveGiftAmountResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.QueryCouponStoreResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.RankEntranceResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.SendGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.ToInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.reporter.IGiftReporter;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetGiftBagParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetToInfoParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadPackageGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadReceiveGiftAmountParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.QueryCouponStoreParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.RankEntranceParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;
import com.yy.mobile.framework.revenuesdk.payapi.reporter.IPayReporter;

import java.util.List;

/**
 * Created by lhf on 2018/7/10.
 * <p>APP 礼物功能service
 * YY.Inc
 */
@Keep
public interface IGiftService {

    /**
     * 获取礼物列表
     *
     * @param param       //请求参数，具体参考{@link LoadAllGiftParam}
     * @param callback    // 请求结果回调
     * @param forceUpdate // 是否强制请求后台数据
     */
    void loadAllGift(@NonNull LoadAllGiftParam param,
                     @NonNull IGiftRequestCallback<LoadAllGiftResult> callback,
                     boolean forceUpdate);

    /**
     * 获取我的包裹列表
     *
     * @param param //请求参数，具体参考{@link LoadPackageGiftParam}
     *              获取的数据走回调接口
     */
    void loadPackageGift(@NonNull LoadPackageGiftParam param,
                         @NonNull IGiftRequestCallback<LoadPackageGiftResult> callback);

    /**
     * 获取用户收到道具数量
     *
     * @param param    //请求参数，具体参考{@link LoadReceiveGiftAmountParam}
     * @param callback
     */
    void loadReceiveGiftAmount(@NonNull LoadReceiveGiftAmountParam param,
                               @NonNull IGiftRequestCallback<LoadReceiveGiftAmountResult> callback);

    /**
     * 赠送礼物给指定用户
     *
     * @param param //请求参数，具体参考{@link SendGiftParam}
     */
    void sendGiftToUser(@NonNull SendGiftParam param,
                        @NonNull IGiftRequestCallback<SendGiftResult> callback);

    /**
     * 赠送礼物给多个用户(全麦送礼)
     *
     * @param param //请求参数，具体参考{@link SendGiftParamV2}
     */
    void sendGiftToMultiUser(@NonNull SendGiftParamV2 param,
                             @NonNull IGiftRequestCallback<SendGiftResult> callback);

    /**
     * 获取用户账户信息
     *
     * @param param    // 请求参数，具体参考{@link GetToInfoParam}
     * @param callback // 接口回调
     */
    void getToInfo(@NonNull GetToInfoParam param,
                   @NonNull IGiftRequestCallback<ToInfoResult> callback);

    /**
     * 获取贡献榜入口值
     *
     * @param param
     * @param callback
     */
    void getRankEntranceInfo(@NonNull RankEntranceParam param,
                             @NonNull IGiftRequestCallback<RankEntranceResult> callback);

    /**
     * 获取活动礼包
     *
     * @param param
     * @param callback
     */
    void getGiftBagInfo(@NonNull GetGiftBagParam param,
                             @NonNull IGiftRequestCallback<GetGiftBagInfoResult> callback);

    /**
     * 获取本地缓存的礼物列表没有则返回空
     *
     * @param usedChannel //渠道id
     * @return allGiftList
     */
    List<GiftInfo> getAllGift(int usedChannel);

    /**
     * 获取本地缓存的礼物列表没有则返回空
     *
     * @param usedChannel    //渠道id
     * @param liveCategoryId //直播品类，海外营收必填
     * @return allGiftList
     */
    List<GiftInfo> getAllGift(int usedChannel, int liveCategoryId);

    /**
     * 查询用户有效优惠券 (非礼勿非支付业务)
     *
     * @param param
     * @param callback
     */
    void queryUserCouponStore(@NonNull QueryCouponStoreParam param,
                              @NonNull IGiftRequestCallback<QueryCouponStoreResult> callback);

    /**
     * 获取当前appId下所有渠道的礼物
     * 此方法已废弃，因为存在礼物id重复的情况，这个接口没意义
     *
     * @return allChannelGift
     */
    @Deprecated
    List<GiftInfo> getAllChannelGift();

    /**
     * 根据礼物id获取缓存中的礼物
     * 该方法存在获取到错误礼物的情况，现已废弃，请使用带usedChannel参数的接口
     *
     * @param propsId //礼物id
     * @return GiftInfo
     */
    @Deprecated
    GiftInfo findGiftById(int propsId);

    /**
     * 根据礼物id获取缓存中的礼物
     *
     * @param propsId     //礼物id
     * @param usedChannel //礼物渠道
     * @return GiftInfo
     */
    GiftInfo findGiftById(int propsId, int usedChannel);

    /**
     * 设置当前直播间的usedChannel
     * 用来获取礼物广播中的礼物的信息
     * 每次进直播间都要设置一下
     *
     * @param usedChannel usedChannel
     */
    void setCurrentUsedChannel(int usedChannel);

    /**
     * 注册giftEventCallback接口
     *
     * @param giftEventCallback giftEventCallback
     */
    void addGiftEventCallback(@NonNull IGiftEventCallback giftEventCallback);

    /**
     * 移除giftEventCallback接口
     *
     * @param giftEventCallback giftEventCallback
     */
    void removeGiftEventCallback(@NonNull IGiftEventCallback giftEventCallback);

    /**
     * 注册上报.
     *
     * @param iGiftReporter
     */
    void registerGiftReporter(IGiftReporter iGiftReporter);

    /**
     * 清除所有礼物缓存信息
     */
    void clearAllGiftCache();

    /**
     * 清除缓存礼物信息(根据usedChannel和liveCategoryId)
     *
     * @param usedChannel
     * @param liveCategoryId
     */
    void clearGiftCacheByChannelAndCategoryId(int usedChannel, int liveCategoryId);

    /**
     * 更新国家码（业务端不要直接调用，请调用updateConfig方法）
     * @param countryCode
     */
    void setCountryCode(String countryCode);

}
