package com.yy.mobile.framework.revenuesdk.gift;

import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAcquireMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAddMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBroInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboFinishInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.MultiGiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.PackageWalletUpdateMessage;

/**
 * Created by lhf on 2018/7/10.
 * <p>
 * YY.Inc
 */

@SuppressWarnings("javadoc")
public interface IGiftEventCallback {

    /**
     * 频道内礼物广播
     *
     * @param appId       //分配给业务的appID
     * @param channelId   //渠道id
     * @param giftBroInfo //礼物广播信息
     */
    void onGiftBroadcastInfo(int appId, int channelId, GiftBroInfo giftBroInfo);

    /**
     * 频道内礼物连击结束特效广播
     *
     * @param appId           //分配给业务的appID
     * @param channelId       //渠道id
     * @param comboFinishInfo //礼物结束广播信息
     */
    void onGiftComboFinishInfo(int appId, int channelId, GiftComboFinishInfo comboFinishInfo);

    /**
     * 礼包发放后，通知客户端刷新包裹单播信息
     */
    void onGiftBagAddUnicast(int appId, int channelId, GiftBagAddMessage message);

    /**
     * @param appId
     * @param channelId
     * @param message
     */
    void onGiftBagAcquireUnicast(int appId, int channelId, GiftBagAcquireMessage message);


    /**
     * 更新货币账户或礼物包裹通知.
     *
     * @param appId
     * @param channelId
     * @param message
     */
    void onPackageWalletUpdate(int appId, int channelId, PackageWalletUpdateMessage message);


    void onMultiGiftBroadcastInfo(int appId, int channelId, MultiGiftInfo multiGiftInfo);
}
