package com.yy.mobile.framework.revenuesdk.gift;

import android.os.Handler;
import android.os.Looper;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by lhf on 2018/8/7.
 * <p>
 * YY.Inc
 */
public class CallbackMode {

    private static CallbackMode mInstance;

    public static CallbackMode getInstance() {
        synchronized (CallbackMode.class) {
            if (mInstance == null) {
                mInstance = new CallbackMode();
            }
        }
        return mInstance;
    }

    private final Handler handler = new Handler(Looper.getMainLooper());
    private Map<String, IGiftRequestCallback> callbackMap = new HashMap<>();

    public void registerCallback(String seq, IGiftRequestCallback callback) {
        callbackMap.put(seq, callback);
    }

    @SuppressWarnings("unchecked")
    public <T> void onCallbackSuccess(String seq, T data) {
        IGiftRequestCallback<T> callback = callbackMap.remove(seq);
        if (callback != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                callback.onSuccess(data);
            } else {
                handler.post(() -> callback.onSuccess(data));
            }
        }
    }

    public void onCallbackFail(String seq, int code, String message) {
        IGiftRequestCallback callback = callbackMap.remove(seq);
        if (callback != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                callback.onFail(code, message);
            } else {
                handler.post(() -> callback.onFail(code, message));
            }
        }
    }
}
