/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenue.gppay;

import android.content.Context;
import android.content.SharedPreferences;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PayTokenCache {
    private static final String TAG = "PayTokenCache";
    private static final String SP_NAME_PAYTOKEN = "SP_NAME_PT";
    private static final String SP_KEY_PAYTOKEN = "SP_KEY_PT_";
    private static final String SPLIT = "##";

    public static void savePayToken(Context context, String productId, PurchaseInfo info) {
        try {
            RLog.info((Object)TAG, (String)("---savePayToken ** " + info.data + ", " + info.signature));
            String value = info.data + SPLIT + info.signature;
            SharedPreferences sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, 0);
            sp.edit().putString(SP_KEY_PAYTOKEN + productId, value).commit();
            RLog.info((Object)TAG, (String)("---savePayToken >> " + value));
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---savePayToken save error = %s", e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static List<PurchaseInfo> readPayToken(Context context) {
        ArrayList<PurchaseInfo> list = new ArrayList<PurchaseInfo>();
        SharedPreferences sp = null;
        try {
            RLog.info((Object)TAG, (String)"---readPayToken **");
            sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, 0);
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---readPayToken read error = %s", e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        if (sp != null) {
            Map allRecord = sp.getAll();
            for (Map.Entry entry : allRecord.entrySet()) {
                try {
                    String value = (String)entry.getValue();
                    RLog.info((Object)TAG, (String)("---readPayToken << " + value));
                    String[] values = value.split(SPLIT);
                    String data = values[0];
                    String signature = values[1];
                    PurchaseInfo purchaseInfo = new PurchaseInfo(data, signature);
                    list.add(purchaseInfo);
                }
                catch (Exception e) {
                    RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---readPayToken read - error = %s", e.toString()), (Object[])new Object[0]);
                }
            }
        }
        return list;
    }

    public static void removePayToken(Context context, String orderId) {
        RLog.error((Object)TAG, (String)("---removePT " + orderId), (Object[])new Object[0]);
        if (context != null && orderId != null && !orderId.isEmpty()) {
            SharedPreferences sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, 0);
            sp.edit().remove(SP_KEY_PAYTOKEN + orderId).commit();
        }
    }

    public static String getProductId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("productId");
                if (tagObject == null) {
                    tagObject = "";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --productId--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , orderId =%s", data, tagObject));
        return tagObject;
    }

    public static String getPayLoad(Context context, String productId) {
        if (context == null) {
            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---reportPurchase read error, context is null", new Object[0]), (Object[])new Object[0]);
            return "";
        }
        try {
            String SP_NAME_PAYLOAD = "SP_NAME_TMP";
            String SP_KEY_PAYLOAD = "SP_KEY_PL_" + productId;
            SharedPreferences sp = context.getSharedPreferences("SP_NAME_TMP", 0);
            RLog.info((Object)TAG, (String)("readPay - key:" + SP_KEY_PAYLOAD));
            return sp.getString(SP_KEY_PAYLOAD, "");
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---reportPurchase read error = %s", e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
            return "";
        }
    }

    public static String getPayLoad(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPayLoad =null ", new Object[0]), (Object[])new Object[0]);
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPayLoad--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser result ---PayCallbackProxy data =%s , getPayLoad =%s", data, tagObject));
        return tagObject;
    }

    public static String getCHOrderId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("chOrderId");
                if (tagObject == null) {
                    tagObject = "";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getCHOrderId--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , chorderId =%s", data, tagObject));
        return tagObject;
    }
}

