/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenue.gppay;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.yy.mobile.framework.revenue.gppay.GPInAppBillingStatus;
import com.yy.mobile.framework.revenue.gppay.PayTokenCache;
import com.yy.mobile.framework.revenue.gppay.diy.IBillingClientConnectCallback;
import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.baseapi.PayCallBackBean;
import com.yy.mobile.framework.revenuesdk.baseapi.PurchaseStatus;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.trace.TraceInfo;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.trace.TraceReport;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.MD5Utils;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.Singleton;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.ThreadPool;
import com.yy.mobile.framework.revenuesdk.payapi.IAcknowledgeCallback;
import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ProductInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.SkuDetailInfo;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.DefaultPayMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class PayMethodImpl
extends DefaultPayMethod
implements PurchasesUpdatedListener {
    private static final int QUERY_RESULT_IS_EMPTY = 301;
    private static final String TAG = "PayMethodImpl";
    private static final long CONNECT_TIME_OUT = 60000L;
    private static final long FOREGROUND_TIME_OUT = 15000L;
    private Context application;
    private boolean isPayStatus = false;
    private IPayCallback<PurchaseInfo> payCallback;
    private long requestTime;
    private long responeTime;
    private Singleton<BillingClient> billingClient = new Singleton<BillingClient>(){

        protected BillingClient create() {
            BillingClient billingClient = BillingClient.newBuilder((Context)PayMethodImpl.this.application).setListener((PurchasesUpdatedListener)PayMethodImpl.this).enablePendingPurchases().build();
            return billingClient;
        }
    };

    public void onPurchasesUpdated(@androidx.annotation.NonNull BillingResult billingResult, @Nullable List<Purchase> purchases) {
        PurchaseInfo info;
        if (this.payCallback == null) {
            return;
        }
        int responseCode = billingResult.getResponseCode();
        int result = -1;
        RLog.info((Object)TAG, (String)"onPurchasesUpdated responseCode = %d", (Object[])new Object[]{responseCode});
        if (responseCode == 0) {
            this.isPayStatus = false;
            if (purchases != null && purchases.size() > 0) {
                info = new PurchaseInfo(purchases.get(0).getOriginalJson(), purchases.get(0).getSignature());
                try {
                    String payload = PayTokenCache.getPayLoad(this.application, PayTokenCache.getProductId(info.data));
                    String developerPayload = PayTokenCache.getPayLoad(payload);
                    JSONObject json = new JSONObject(info.data);
                    json.put("developerPayload", (Object)developerPayload);
                    String chOrderId = PayTokenCache.getCHOrderId(payload);
                    if (chOrderId != null && !chOrderId.isEmpty()) {
                        json.put("chOrderId", (Object)chOrderId);
                    }
                    String purchaseData = json.toString();
                    info = new PurchaseInfo(purchaseData, purchases.get(0).getSignature());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                PayTokenCache.savePayToken(this.application, purchases.get(0).getOrderId(), info);
                RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "onPurchasesUpdate -- PurchaseInfo\uff1adata =%s , sign =%s", info.data, info.signature));
                this.payCallback.onSuccess((Object)info, null);
                result = 0;
            } else {
                this.payCallback.onFail(GPInAppBillingStatus.ERROR_PURCHASES_INFO_EMPTY.getCode(), GPInAppBillingStatus.ERROR_PURCHASES_INFO_EMPTY.getMessage(), null);
                result = 1;
            }
        } else {
            this.isPayStatus = false;
            GPInAppBillingStatus status = GPInAppBillingStatus.valueOf(responseCode);
            this.payCallback.onFail(status.getCode(), status.getMessage(), null);
            result = 1;
        }
        if (result != -1) {
            try {
                info = TraceReport.getInstance().getCacheInfo("TRACE_FOR_PAY_PAGE");
                info.setCompletetime(System.currentTimeMillis() - info.getApptime());
                info.setResult(result == 0 ? "Success" : "Fail");
                info.setReturncode(String.valueOf(responseCode));
                TraceReport.getInstance().doReport((TraceInfo)info);
            }
            catch (Exception e) {
                RLog.error((Object)TAG, (String)"TraceReport onPurchasesUpdated error.", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public void appHasReturnToForegroud() {
        RLog.info((Object)TAG, (String)("appHasReturnToForegroud isPayStatus = " + this.isPayStatus));
        if (this.isPayStatus) {
            if (this.payCallback == null) {
                return;
            }
            Runnable timeoutTask = new Runnable(){

                @Override
                public void run() {
                    RLog.info((Object)PayMethodImpl.TAG, (String)("appHasReturnToForegroud onFail = %d" + GPInAppBillingStatus.PAY_DIALOG_EXIT_WITHOUT_CALLBACK.code));
                    PayMethodImpl.this.payCallback.onFail(GPInAppBillingStatus.PAY_DIALOG_EXIT_WITHOUT_CALLBACK.code, GPInAppBillingStatus.PAY_DIALOG_EXIT_WITHOUT_CALLBACK.message, null);
                }
            };
            ThreadPool.getDefault().mainThreadIO().postDelay(timeoutTask, 15000L);
        }
    }

    public boolean hasHangPayJobs(final @org.jetbrains.annotations.Nullable Context act, final @org.jetbrains.annotations.Nullable IResult<List<PurchaseInfo>> iResult) {
        RLog.info((Object)TAG, (String)"---hasHangPayJobs---");
        this.application = act;
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        iResult.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.hasHangJobInternal(act, "inapp", (IResult<List<PurchaseInfo>>)iResult);
                    }
                }

                @Override
                public void onDisconnected() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.hasHangJobInternal(act, "inapp", iResult);
        }
        return true;
    }

    public boolean hasHangSubscribeJobs(final @org.jetbrains.annotations.Nullable Context act, final @org.jetbrains.annotations.Nullable IResult<List<PurchaseInfo>> iResult) {
        RLog.info((Object)TAG, (String)"---hasHangSubscribeJobs---");
        this.application = act;
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        iResult.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.hasHangJobInternal(act, "subs", (IResult<List<PurchaseInfo>>)iResult);
                    }
                }

                @Override
                public void onDisconnected() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.hasHangJobInternal(act, "subs", iResult);
        }
        return true;
    }

    public boolean queryHistoryPurchaseBySkuType(@NonNull Context act, String skuType, IResult<List<PurchaseInfo>> iResult) {
        if (skuType.equals("inapp")) {
            this.hasHangPayJobs(act, iResult);
        } else if (skuType.equals("subs")) {
            this.hasHangSubscribeJobs(act, iResult);
        } else {
            iResult.onFail(-1, "no support skutype", null);
        }
        return false;
    }

    public boolean doHangJob(Context context, String orderId, final @NonNull PurchaseInfo info, final IResult<String> result) {
        PayTokenCache.removePayToken(context, orderId);
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        result.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.doHangJobInternal(info, (IResult<String>)result);
                    }
                }

                @Override
                public void onDisconnected() {
                    result.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    result.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.doHangJobInternal(info, result);
        }
        return true;
    }

    public boolean isSupported(Context context) {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int ret = googleAPI.isGooglePlayServicesAvailable(context);
        return ret == 0;
    }

    public void requestPay(Activity act, long uid, ProductInfo produce, String payload, boolean isSetAccountId, IPayCallback<PurchaseInfo> callback) {
        this.requestPay(act, uid, produce.productId, payload, isSetAccountId, callback);
    }

    public void requestPay(final Activity act, final long uid, final String productId, final String payload, final boolean isSetAccountId, final IPayCallback<PurchaseInfo> callback) {
        if (callback == null) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
        this.payCallback = callback;
        this.application = act.getApplication();
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "---requestPay uid = %d,productId = %s, payload = %s ,requestTime = %s ---", uid, productId, payload, this.requestTime));
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        PayCallBackBean payCallBackBean = new PayCallBackBean(null, productId, null, PayMethodImpl.this.requestTime, null, payload, null, null, PurchaseStatus.PAY_FAIL);
                        callback.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, payCallBackBean);
                        callback.onPayStatus(PurchaseStatus.PAY_FAIL, payCallBackBean);
                    } else {
                        PayMethodImpl.this.requestPayInternal(act, productId, payload, uid, isSetAccountId);
                    }
                }

                @Override
                public void onDisconnected() {
                    PayCallBackBean payCallBackBean = new PayCallBackBean(null, productId, null, PayMethodImpl.this.requestTime, null, payload, null, null, PurchaseStatus.PAY_FAIL);
                    callback.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), payCallBackBean);
                    callback.onPayStatus(PurchaseStatus.PAY_FAIL, payCallBackBean);
                }

                @Override
                public void onTimeOut() {
                    PayCallBackBean payCallBackBean = new PayCallBackBean(null, productId, null, PayMethodImpl.this.requestTime, null, payload, null, null, PurchaseStatus.PAY_FAIL);
                    callback.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, payCallBackBean);
                    callback.onPayStatus(PurchaseStatus.PAY_FAIL, payCallBackBean);
                }
            });
        } else {
            this.requestPayInternal(act, productId, payload, uid, isSetAccountId);
        }
    }

    public void requestSubscription(final Activity act, final long uid, final String productId, final String payload, final boolean isSetAccountId, final IPayCallback<PurchaseInfo> callback) {
        if (callback == null) {
            return;
        }
        this.payCallback = callback;
        this.application = act;
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "---requestSubscription uid = %d,productId = %s, payload = %s---", uid, productId, payload));
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        callback.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.requestPaySubscription(act, productId, payload, uid, isSetAccountId);
                    }
                }

                @Override
                public void onDisconnected() {
                    callback.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    callback.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.requestPaySubscription(act, productId, payload, uid, isSetAccountId);
        }
    }

    public void acknowledgePurchase(String purchaseToken, final IAcknowledgeCallback callback) {
        AcknowledgePurchaseParams params = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(purchaseToken).build();
        ((BillingClient)this.billingClient.get()).acknowledgePurchase(params, new AcknowledgePurchaseResponseListener(){

            public void onAcknowledgePurchaseResponse(@androidx.annotation.NonNull BillingResult billingResult) {
                callback.onAcknowledgeResult(billingResult.getResponseCode(), billingResult.getDebugMessage());
            }
        });
    }

    public void updateSubscription(final Activity act, final long uid, final String oldProductId, final String newProductId, final int prorationMode, final String payload, final boolean isSetAccountId, final IPayCallback<PurchaseInfo> callback) {
        if (callback == null) {
            return;
        }
        this.payCallback = callback;
        this.application = act;
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "---updateSubscription uid = %d,oldProductId = %s, newProductId = %s,prorationMode = %d,payload = %s---", uid, oldProductId, newProductId, prorationMode, payload));
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        callback.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.requestUpdateSubscription(act, newProductId, oldProductId, uid, prorationMode, payload, isSetAccountId);
                    }
                }

                @Override
                public void onDisconnected() {
                    callback.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    callback.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.requestUpdateSubscription(act, newProductId, oldProductId, uid, prorationMode, payload, isSetAccountId);
        }
    }

    public boolean queryHistoryPurchaseByProductId(final String product, final IResult<PurchaseInfo> iResult) {
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        iResult.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.queryHistoryPurchaseByProductIdInternal(product, (IResult<PurchaseInfo>)iResult);
                    }
                }

                @Override
                public void onDisconnected() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.queryHistoryPurchaseByProductIdInternal(product, iResult);
        }
        return true;
    }

    private void queryHistoryPurchaseByProductIdInternal(String product, IResult<PurchaseInfo> iResult) {
        ((BillingClient)this.billingClient.get()).queryPurchaseHistoryAsync("inapp", (response, purchasesList) -> {
            if (response.getResponseCode() == 0 && purchasesList != null) {
                for (PurchaseHistoryRecord purchase : purchasesList) {
                    if (!product.equals(purchase.getSku())) continue;
                    iResult.onSuccess((Object)new PurchaseInfo(purchase.getOriginalJson(), purchase.getSignature()), null);
                    return;
                }
            }
            iResult.onFail(response.getResponseCode(), "query fail!", null);
        });
    }

    public boolean querySkuDetails(Context act, final List<String> skusList, final String skuType, final IResult<List<SkuDetailInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        this.application = act;
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        iResult.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.querySkuDetailsInternal(skusList, skuType, (IResult<List<SkuDetailInfo>>)iResult);
                    }
                }

                @Override
                public void onDisconnected() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.querySkuDetailsInternal(skusList, skuType, iResult);
        }
        return false;
    }

    private void querySkuDetailsInternal(List<String> skusList, String skuType, IResult<List<SkuDetailInfo>> iResult) {
        SkuDetailsParams skuDetailsParams = this.getSkuDetailsParams(skusList, skuType);
        ArrayList skuInfoList = new ArrayList();
        ((BillingClient)this.billingClient.get()).querySkuDetailsAsync(skuDetailsParams, (responseCode, skuDetailsList) -> {
            if (responseCode.getResponseCode() == 0 && skuDetailsList != null) {
                for (SkuDetails skuDetails : skuDetailsList) {
                    if (skuDetails == null) continue;
                    SkuDetailInfo skuDetailInfo = new SkuDetailInfo();
                    skuDetailInfo.description = skuDetails.getDescription();
                    skuDetailInfo.freeTrialPeriod = skuDetails.getFreeTrialPeriod();
                    skuDetailInfo.introductoryPrice = skuDetails.getIntroductoryPrice();
                    skuDetailInfo.introductoryPriceAmountMicros = skuDetails.getIntroductoryPriceAmountMicros();
                    skuDetailInfo.introductoryPriceCycles = skuDetails.getIntroductoryPriceCycles();
                    skuDetailInfo.price = skuDetails.getPrice();
                    skuDetailInfo.priceAmountMicros = skuDetails.getPriceAmountMicros();
                    skuDetailInfo.priceCurrencyCode = skuDetails.getPriceCurrencyCode();
                    skuDetailInfo.priceCurrencyCode = skuDetails.getPriceCurrencyCode();
                    skuDetailInfo.sku = skuDetails.getSku();
                    skuDetailInfo.subscriptionPeriod = skuDetails.getSubscriptionPeriod();
                    skuDetailInfo.title = skuDetails.getTitle();
                    skuDetailInfo.type = skuDetails.getType();
                    skuInfoList.add(skuDetailInfo);
                }
                iResult.onSuccess((Object)skuInfoList, null);
            } else {
                iResult.onFail(responseCode.getResponseCode(), "querySkuDetails fail!", null);
            }
        });
    }

    private SkuDetailsParams getSkuDetailsParams(List<String> skusList, String skuType) {
        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setSkusList(skusList).setType(skuType).build();
        return skuDetailsParams;
    }

    public boolean isPayingStatus() {
        return this.isPayStatus;
    }

    private int requestPayInternal(final Activity act, final String productId, final String payload, final long uid, final boolean isSetAccountId) {
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.add(productId);
        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setSkusList(skuList).setType("inapp").build();
        ((BillingClient)this.billingClient.get()).querySkuDetailsAsync(skuDetailsParams, new SkuDetailsResponseListener(){

            public void onSkuDetailsResponse(@androidx.annotation.NonNull BillingResult billingResult, @Nullable List<SkuDetails> skuDetailsList) {
                if (billingResult.getResponseCode() == 0) {
                    if (skuDetailsList.size() == 0) {
                        RLog.error((Object)PayMethodImpl.TAG, (String)String.format(Locale.ENGLISH, "onSkuDetailsResponse skuDetails is empty!!!", new Object[0]), (Object[])new Object[0]);
                        if (PayMethodImpl.this.payCallback != null) {
                            PayMethodImpl.this.payCallback.onFail(GPInAppBillingStatus.ERROR_PURCHASES_INFO_EMPTY.getCode(), GPInAppBillingStatus.ERROR_PURCHASES_INFO_EMPTY.getMessage(), null);
                        }
                        return;
                    }
                    BillingFlowParams flowParams = PayMethodImpl.this.getBillingFlowParams(productId, payload, uid, isSetAccountId, skuDetailsList.get(0));
                    int billingResponseCode = PayMethodImpl.this.startPay(act, flowParams, payload, productId);
                    if (billingResponseCode == 0) {
                        // empty if block
                    }
                }
            }
        });
        return 0;
    }

    private int startPay(Activity act, BillingFlowParams flowParams, String payload, String productId) {
        try {
            String SP_NAME_PAYLOAD = "SP_NAME_TMP";
            String SP_KEY_PAYLOAD = "SP_KEY_PL_" + productId;
            SharedPreferences sp = act.getSharedPreferences("SP_NAME_TMP", 0);
            sp.edit().putString(SP_KEY_PAYLOAD, payload).commit();
            RLog.info((Object)TAG, (String)("savePay: (" + SP_KEY_PAYLOAD + ")" + payload));
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "---startPay save error = %s", e.toString()), (Object[])new Object[0]);
            e.printStackTrace();
        }
        int code = ((BillingClient)this.billingClient.get()).launchBillingFlow(act, flowParams).getResponseCode();
        this.payCallback.onPayStart();
        this.isPayStatus = true;
        return code;
    }

    private BillingFlowParams getBillingFlowParams(String productId, String payload, long uid, boolean isSetAccountId, SkuDetails skuDetails) {
        String MD5Uid = MD5Utils.md5((String)String.valueOf(uid));
        BillingFlowParams flowParams = isSetAccountId ? BillingFlowParams.newBuilder().setSkuDetails(skuDetails).setObfuscatedAccountId(MD5Uid).build() : BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
        return flowParams;
    }

    private int requestPaySubscription(final Activity act, final String productId, final String payload, final long uid, final boolean isSetAccountId) {
        BillingResult r = ((BillingClient)this.billingClient.get()).isFeatureSupported("subscriptions");
        int resCode = r.getResponseCode();
        if (resCode != 0) {
            RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "requestPaySubscription %s", r.getDebugMessage()));
            return resCode;
        }
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.add(productId);
        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setSkusList(skuList).setType("subs").build();
        ((BillingClient)this.billingClient.get()).querySkuDetailsAsync(skuDetailsParams, new SkuDetailsResponseListener(){

            public void onSkuDetailsResponse(@androidx.annotation.NonNull BillingResult billingResult, @Nullable List<SkuDetails> skuDetailsList) {
                BillingFlowParams flowParams;
                int billingResponseCode;
                if (billingResult.getResponseCode() != 0 || (billingResponseCode = PayMethodImpl.this.startPay(act, flowParams = PayMethodImpl.this.getPaySubscriptionBillingFlowParams(productId, payload, uid, isSetAccountId, skuDetailsList.get(0)), payload, productId)) == 0) {
                    // empty if block
                }
            }
        });
        return 0;
    }

    private BillingFlowParams getPaySubscriptionBillingFlowParams(String productId, String payload, long uid, boolean isSetAccountId, SkuDetails skuDetails) {
        String MD5Uid = MD5Utils.md5((String)String.valueOf(uid));
        BillingFlowParams flowParams = isSetAccountId ? BillingFlowParams.newBuilder().setSkuDetails(skuDetails).setObfuscatedAccountId(MD5Uid).build() : BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
        return flowParams;
    }

    private int requestUpdateSubscription(Activity act, String productId, String oldProductId, long uid, int prorationMode, String payload, boolean isSetAccountId) {
        BillingResult r = ((BillingClient)this.billingClient.get()).isFeatureSupported("subscriptions");
        int resCode = r.getResponseCode();
        if (resCode != 0) {
            RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "requestUpdateSubscription %s", r.getDebugMessage()));
            return resCode;
        }
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.add(productId);
        SkuDetailsParams skuDetailsParams = SkuDetailsParams.newBuilder().setSkusList(skuList).setType("subs").build();
        ((BillingClient)this.billingClient.get()).querySkuDetailsAsync(skuDetailsParams, (billingResult, skuDetailsList) -> {
            BillingFlowParams flowParams;
            int billingResponseCode;
            if (billingResult.getResponseCode() != 0 || (billingResponseCode = this.startPay(act, flowParams = this.getUpdateSubscriptionBillingFlowParams(productId, oldProductId, payload, uid, prorationMode, isSetAccountId, (SkuDetails)skuDetailsList.get(0)), payload, productId)) == 0) {
                // empty if block
            }
        });
        return 0;
    }

    private BillingFlowParams getUpdateSubscriptionBillingFlowParams(String productId, String oldProductId, String payload, long uid, int prorationMode, boolean isSetAccountId, SkuDetails skuDetails) {
        String MD5Uid = MD5Utils.md5((String)String.valueOf(uid));
        BillingFlowParams flowParams = isSetAccountId ? BillingFlowParams.newBuilder().setSkuDetails(skuDetails).setOldSku(oldProductId, "").setReplaceSkusProrationMode(prorationMode).setObfuscatedAccountId(MD5Uid).build() : BillingFlowParams.newBuilder().setSkuDetails(skuDetails).setOldSku(oldProductId, "").setReplaceSkusProrationMode(prorationMode).build();
        return flowParams;
    }

    private void doHangJobInternal(PurchaseInfo info, IResult<String> result) {
        block2: {
            try {
                Purchase purchase = new Purchase(info.data, info.signature);
                ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                ((BillingClient)this.billingClient.get()).consumeAsync(consumeParams, (responseCode, purchaseToken) -> {
                    RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "onConsumeResponse responseCode = %d,purchaseToken=%s", responseCode.getResponseCode(), purchaseToken));
                    if (result != null) {
                        if (responseCode.getResponseCode() == 0) {
                            RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "onConsumeResponse---onSuccess responseCode = %d, purchaseToken=%s", responseCode.getResponseCode(), purchaseToken));
                            result.onSuccess((Object)purchaseToken, null);
                        } else {
                            RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "onConsumeResponse---onFail responseCode = %d, purchaseToken=%s", responseCode.getResponseCode(), purchaseToken), (Object[])new Object[0]);
                            result.onFail(responseCode.getResponseCode(), "consume fail", null);
                        }
                    }
                });
            }
            catch (Exception e) {
                RLog.error((Object)TAG, (String)("onPaySuccess errorMsg = " + e.getMessage()), (Object[])new Object[0]);
                if (result == null) break block2;
                result.onFail(-1, "consume fail! Exception:" + e.getMessage(), null);
            }
        }
    }

    private boolean hasHangJobInternal(Context context, String skuType, IResult<List<PurchaseInfo>> iResult) {
        Purchase.PurchasesResult result = ((BillingClient)this.billingClient.get()).queryPurchases(skuType);
        return this.onHasHangJobInternal(context, result, iResult);
    }

    private boolean onHasHangJobInternal(Context context, Purchase.PurchasesResult result, IResult<List<PurchaseInfo>> iResult) {
        if (result.getResponseCode() == 0) {
            List list = result.getPurchasesList();
            if (list != null && list.size() != 0) {
                ArrayList<PurchaseInfo> resultList = new ArrayList<PurchaseInfo>();
                for (Purchase purchase : list) {
                    String data = purchase.getOriginalJson();
                    String sign = purchase.getSignature();
                    resultList.add(new PurchaseInfo(data, sign));
                }
                RLog.info((Object)TAG, (String)("resultList size: " + resultList.size()));
                iResult.onSuccess(resultList, null);
            } else {
                iResult.onFail(301, " List size=0", null);
            }
            return true;
        }
        iResult.onFail(result.getResponseCode(), "query fail!", null);
        return false;
    }

    public void clearHangPayJob(Context act, int type, final IResult<PurchaseInfo> iResult) {
        this.application = act;
        if (!this.isReady()) {
            this.startConnection(new IBillingClientConnectCallback(){

                @Override
                public void onSetupFinished(int responseCode) {
                    if (responseCode == GPInAppBillingStatus.BILLING_UNAVAILABLE.code) {
                        iResult.onFail(responseCode, GPInAppBillingStatus.BILLING_UNAVAILABLE.message, null);
                    } else {
                        PayMethodImpl.this.clearAllHangPayJobInternal((IResult<PurchaseInfo>)iResult);
                    }
                }

                @Override
                public void onDisconnected() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_DISCONNECTED.code, GPInAppBillingStatus.SERVICE_DISCONNECTED.getMessage(), null);
                }

                @Override
                public void onTimeOut() {
                    iResult.onFail(GPInAppBillingStatus.SERVICE_TIMEOUT.code, GPInAppBillingStatus.SERVICE_TIMEOUT.message, null);
                }
            });
        } else {
            this.clearAllHangPayJobInternal(iResult);
        }
    }

    private void clearAllHangPayJobInternal(IResult<PurchaseInfo> iResult) {
        Purchase.PurchasesResult result = ((BillingClient)this.billingClient.get()).queryPurchases("inapp");
        if (result.getResponseCode() != 0) {
            iResult.onFail(result.getResponseCode(), "BillingResponse not ok", null);
            return;
        }
        List mPurchaseList = result.getPurchasesList();
        if (mPurchaseList == null || mPurchaseList.isEmpty()) {
            iResult.onFail(-1, "no unConsume pay", null);
            return;
        }
        try {
            for (Purchase info : mPurchaseList) {
                Purchase purchase = new Purchase(info.getOriginalJson(), info.getSignature());
                ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                ((BillingClient)this.billingClient.get()).consumeAsync(consumeParams, (responseCode, purchaseToken) -> {
                    RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "onConsumeResponse responseCode = %d,purchaseToken=%s", responseCode.getResponseCode(), purchaseToken));
                    iResult.onSuccess((Object)new PurchaseInfo(purchase.getOriginalJson(), purchase.getSignature()), null);
                });
            }
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)("onPaySuccess errorMsg = " + e.getMessage()), (Object[])new Object[0]);
        }
    }

    private boolean isReady() {
        return ((BillingClient)this.billingClient.get()).isReady();
    }

    private void startConnection(final IBillingClientConnectCallback callback) {
        final GpConnectTaskInfo gpConnectTaskInfo = new GpConnectTaskInfo(callback);
        ((BillingClient)this.billingClient.get()).startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(@androidx.annotation.NonNull BillingResult billingResult) {
                gpConnectTaskInfo.release();
                callback.onSetupFinished(billingResult.getResponseCode());
            }

            public void onBillingServiceDisconnected() {
                gpConnectTaskInfo.release();
                callback.onDisconnected();
            }
        });
    }

    private static class GpConnectTaskInfo {
        IBillingClientConnectCallback callback;
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                callback.onTimeOut();
            }
        };

        GpConnectTaskInfo(IBillingClientConnectCallback callback) {
            this.callback = callback;
            ThreadPool.getDefault().mainThreadIO().postDelay(this.timeoutTask, 60000L);
        }

        void release() {
            ThreadPool.getDefault().mainThreadIO().removeCallback(this.timeoutTask);
        }
    }
}

