//package com.yy.mobile.framework.revenue.gppay;
//
//import android.app.Activity;
//import android.app.PendingIntent;
//import android.content.ComponentName;
//import android.content.Context;
//import android.content.Intent;
//import android.content.IntentSender;
//import android.content.ServiceConnection;
//import android.os.Bundle;
//import android.os.IBinder;
//import android.os.RemoteException;
//import android.os.ResultReceiver;
//
//
//import com.yy.mobile.framework.revenue.gppay.billingclient.api.BillingClient;
//import com.yy.mobile.framework.revenue.gppay.billingclient.api.Purchase;
//import com.yy.mobile.framework.revenue.gppay.billingclient.api.SkuDetails;
//import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
//import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
//import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
//import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
//
//import org.json.JSONException;
//
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.List;
//
//
///**
// * Created by ouyangshaocong on 2018/7/19.
// */
//class GpPayEngine implements IGpPayEngine {
//
//    public static final String TAG = "gp.GpPayEngine";
//
//    // A list of SKUs inside getSkuDetails request bundle.
//    private static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
//    // Keys for the responses from InAppBillingService
//    public static final String RESPONSE_CODE = "RESPONSE_CODE";
//    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
//    public static final String RESPONSE_BUY_INTENT = "BUY_INTENT";
//    public static final String RESPONSE_DATA_INTENT = "DATA_INTENT";
//    // StringArrayList containing the list of SKUs
//    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
//    // StringArrayList containing the purchase information
//    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
//    // StringArrayList containing the signatures of the purchase information
//    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
//    // Keys for Purchase data parsing
//    public static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
//    public static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
//    // Keys for Purchase info parsing
//    public static final String RESPONSE_INAPP_PURCHASE_INFO = "INAPP_PURCHASE_INFO";
//    // Request code for resolve gps
//    public static final int PLAY_SERVICES_RESOLUTION_REQUEST = 0x7093934;
//
//    private Context appContext;
//    private EngineStatus engineStatus = EngineStatus.ENGINE_STOP;
//    private GpRequest currentRequest;
//    private IPayCallback<PurchaseInfo> iPayCallback;
//    private IResult<List<PurchaseInfo>> iQueryResult; // 查询回调接口.
//
//    /**
//     * gp服务binder
//     */
//    IInAppBillingService mService;
//
//    /**
//     * gp服务连接
//     */
//    ServiceConnection mServiceConn = new ServiceConnection() {
//        @Override
//        public void onServiceDisconnected(ComponentName name) {
//            mService = null;
//        }
//
//        @Override
//        public void onServiceConnected(ComponentName name, IBinder service) {
//            mService = IInAppBillingService.Stub.asInterface(service);
//            //回调绑定服务成功
//            onEngineStart();
//        }
//    };
//
//    boolean isBind = false;
//
//    @Override
//    public boolean startEngine(Context context) {
//        return startService(context);
//    }
//
//    @Override
//    public void stopEngine() {
//        stopService();
//    }
//
//    @Override
//    public void sendRequest(GpRequest request, IPayCallback<PurchaseInfo> callback) {
//        if (request == null || !request.isValid()) {
//            RLog.info(TAG, "error request null");
//            if (callback != null) {
//                callback.onFail(GPInAppBillingStatus.DEVELOPER_ERROR.getCode(),
//                        GPInAppBillingStatus.DEVELOPER_ERROR.getMessage());
//            }
//            return;
//        }
//        if (engineStatus == EngineStatus.ENGINE_BUSY) {
//            RLog.info(TAG, "engine is busy...");
//            if (callback != null) {
//                callback.onFail(GPInAppBillingStatus.ENGINE_BUSY.getCode(),
//                        GPInAppBillingStatus.ENGINE_BUSY.getMessage());
//            }
//            return;
//        }
//        currentRequest = request;
//        iPayCallback = callback;
//
//        if (engineStatus != EngineStatus.ENGINE_START) {
//            if (!startEngine(request.context)) {
//                RLog.info(TAG, "start engine fail...");
//                if (callback != null) {
//                    callback.onFail(GPInAppBillingStatus.ERROR.getCode(),
//                            GPInAppBillingStatus.ERROR.getMessage());
//                }
//            }
//        }
//    }
//
//    @Override
//    public void consume(Context context, String data, String sign) {
//        if (engineStatus != EngineStatus.ENGINE_STOP) {
//            try {
//                Purchase purchase = new Purchase(data, sign);
//                consumePurchase(purchase.getPurchaseToken());
//            } catch (JSONException | RemoteException e) {
//                RLog.error(TAG, "consumePurchase", e);
//            }
//        } else {
//            startEngine(context);
//        }
//    }
//
//    @Override
//    public boolean hasHangPayJob(Activity act, IResult<List<PurchaseInfo>> iResult) {
//        if (engineStatus == EngineStatus.ENGINE_STOP) {
//            this.iQueryResult = iResult;
//            startEngine(act);
//        } else {
//            try {
//                iResult.onSuccess(getPurchases());
//            } catch (RemoteException e) {
//                iResult.onFail(-1, e.getMessage());
//            }
//        }
//        return false;
//    }
//
//    public boolean hasJobWorking() {
//        return engineStatus != EngineStatus.ENGINE_STOP;
//    }
//
//    public GpRequest obtainRequest() {
//        return new GpRequest();
//    }
//
//    /**
//     * 启动服务
//     *
//     * @param context
//     */
//    private boolean startService(Context context) {
//        if (null == context) {
//            RLog.error("GpPayEngine", "startService error. context is null.");
//            return false;
//        }
//        appContext = context.getApplicationContext();
//        //绑定in-app billing服务
//        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
//        serviceIntent.setPackage("com.android.vending");
//        isBind = appContext.bindService(serviceIntent, mServiceConn, Context.BIND_AUTO_CREATE);
//        return isBind;
//    }
//
//    /**
//     * 停止服务
//     */
//    private void stopService() {
//        if (null == mService) {
//            RLog.error("GpPayEngine", "stopService error. service is not alive.");
//            return;
//        }
//        if (null == appContext) {
//            RLog.error("GpPayEngine", "stopService error. context is null.");
//            return;
//        }
//        if (isBind) {
//            appContext.unbindService(mServiceConn);
//        }
//        isBind = false;
//        mService = null;
//        currentRequest = null;
//        appContext = null;
//        iQueryResult = null;
//        engineStatus = EngineStatus.ENGINE_STOP;
//    }
//
//    public void onEngineStart() {
//        RLog.info(TAG, "onEngineStart()");
//        engineStatus = EngineStatus.ENGINE_START;
//        try {
//            // 这里已经乱得我自己都看不下去了.
//            List<PurchaseInfo> purchases = getPurchases();
//            if (iQueryResult != null) {
//                iQueryResult.onSuccess(purchases);
//                stopEngine();
//                return;
//            }
//            if (null != purchases && !purchases.isEmpty()) {
//                if (iPayCallback != null) {
//                    //感觉这里是有点问题的,既然是返回了支付失败了.
//                    //那为何下面还要接着走支付.
////                    iPayCallback.onFail(GPInAppBillingStatus.ITEM_ALREADY_OWNED.getCode(),
////                            GPInAppBillingStatus.ITEM_ALREADY_OWNED.getMessage());
//                }
//                for (PurchaseInfo info : purchases) {
//                    try {
//                        Purchase purchase = new Purchase(info.data, info.signature);
//                        consumePurchase(purchase.getPurchaseToken());
//                    } catch (JSONException | RemoteException e) {
//                        RLog.error(TAG, "consumePurchase", e);
//                    }
//                }
//            }
//
//            if (currentRequest == null || iPayCallback == null) {
//                stopEngine();
//                return;
//            }
//            //消耗完成后，继续购买产品
//            if (!requestBillingBy(currentRequest.context, currentRequest.sku, currentRequest.payload)) {
//                if (iPayCallback != null) {
//                    iPayCallback.onFail(GPInAppBillingStatus.BILLING_UNAVAILABLE.getCode(),
//                            GPInAppBillingStatus.BILLING_UNAVAILABLE.getMessage());
//                }
//            } else {
//                // 这里我们认为是已经成功跳转到GP的支付页面去
//                if (iPayCallback != null) {
//                    iPayCallback.onPayStart();
//                }
//                engineStatus = EngineStatus.ENGINE_BUSY;
//            }
//        } catch (RemoteException | IntentSender.SendIntentException e) {
//            //TODO 错误不用处理?!
//            RLog.error(TAG, "onBindService error.", e);
//            if (iQueryResult != null) {
//                iQueryResult.onFail(-2, e.getMessage());
//            }
//        }
//    }
//
//
//    private void handleActivityResult(int resultCode, Intent data) {
//        if (data != null) {
//            Bundle extras = data.getExtras();
//            if (extras != null) {
//                for (String key : extras.keySet()) {
//                    RLog.info(TAG, "intent extras: key = %s, value = %s", key, extras.get(key));
//                }
//            }
//        }
//        int responseCode = GPInAppBillingStatus.UNKNOWN.getCode();
//        PurchaseInfo info = new PurchaseInfo();
//        if (null != data && resultCode == Activity.RESULT_OK) {
//            String purchaseData = data.getStringExtra(GpPayEngine.RESPONSE_INAPP_PURCHASE_DATA);
//            String purchaseSign = data.getStringExtra(GpPayEngine.RESPONSE_INAPP_SIGNATURE);
//            info = new PurchaseInfo(purchaseData, purchaseSign);
//            responseCode = data.getIntExtra(GpPayEngine.RESPONSE_CODE, responseCode);
//        } else if (resultCode == Activity.RESULT_CANCELED) {
//            // 根据Google的官方文档，用户取消行为可以通过读取RESPONSE_CODE来获取
//            // https://developer.android.com/google/play/billing/billing_reference
//            // 不过这里好像不用继续读取RESPONSE_CODE了,取消的时候resultCode == RESULT_CANCELED恒成立.
//            //responseCode = data.getIntExtra(GpPayEngine.RESPONSE_CODE, responseCode);
//            stopEngine();
//            if (iPayCallback != null) {
//                iPayCallback.onFail(GPInAppBillingStatus.USER_CANCELED.getCode(),
//                        GPInAppBillingStatus.USER_CANCELED.getMessage());
//            }
//        }
//        //消费内购商品
//        GPInAppBillingStatus status = GPInAppBillingStatus.valueOf(responseCode);
//        if (status == GPInAppBillingStatus.OK || status == GPInAppBillingStatus.ITEM_ALREADY_OWNED) {
//            if (iPayCallback != null) {
//                iPayCallback.onSuccess(info);
//            }
//        } else {
//            // TODO 失败做重试?
////            if (iPayCallback != null) {
////                iPayCallback.onFail(status.getCode(), status.getMessage());
////            }
//        }
//    }
//
//
//    //================================以下gp接口实现==================================================//
//
//    /**
//     * 查询sku商品列表详情
//     *
//     * @param products
//     */
//    public List<SkuDetails> getSkuDetails(String... products) throws RemoteException {
//        List<SkuDetails> skus = new ArrayList<>();
//        if (null == products || products.length <= 0) {
//            RLog.error("GpPayEngine", "getSkuDetails error. sku list is empty.");
//            return skus;
//        }
//        if (null == mService) {
//            RLog.error("GpPayEngine", "getSkuDetails error. service is not alive.");
//            return skus;
//        }
//        int sup = mService.isBillingSupported(3, appContext.getPackageName(), BillingClient.SkuType.INAPP);
//        if (GPInAppBillingStatus.valueOf(sup) != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getSkuDetails error. not support." + sup);
//            return skus;
//        }
//        Bundle bundle = new Bundle();
//        ArrayList<String> list = new ArrayList<>(Arrays.asList(products));
//        bundle.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, list);
//        Bundle result = mService.getSkuDetails(3, appContext.getPackageName(), BillingClient.SkuType.INAPP, bundle);
//        //返回结果处理
//        int ret = result.getInt(RESPONSE_CODE);
//        if (ret != 0) {
//            RLog.error("GpPayEngine", "getSkuDetails error. response code."
//            + GPInAppBillingStatus.valueOf(ret).message);
//            return skus;
//        }
//        ArrayList<String> response = result.getStringArrayList(RESPONSE_GET_SKU_DETAILS_LIST);
//        if (null == response) {
//            RLog.error("GpPayEngine", "getSkuDetails error. response list is empty.");
//            return skus;
//        }
//        SkuDetails sku;
//        for (String detail : response) {
//            try {
//                sku = new SkuDetails(detail);
//                skus.add(sku);
//            } catch (JSONException e) {
//                RLog.error("GpPayEngine", "getSkuDetails error. parse error." + detail);
//            }
//        }
//        return skus;
//    }
//
//    /**
//     * 请求购买流程
//     *
//     * @param act
//     * @param sku
//     * @param payload
//     * @throws RemoteException
//     * @throws IntentSender.SendIntentException
//     */
//    public boolean requestBillingBy(Activity act, String sku, String payload)
//    throws RemoteException, IntentSender.SendIntentException {
//        if (null == sku || null == payload) {
//            RLog.error("GpPayEngine", "requestBillingBy error. wrong args." + sku + ", " + payload);
//            return false;
//        }
//        if (null == mService || appContext == null) {
//            RLog.error("GpPayEngine", "requestBillingBy error. service is not alive.");
//            return false;
//        }
//        int sup = mService.isBillingSupported(3, appContext.getPackageName(), BillingClient.SkuType.INAPP);
//        if (GPInAppBillingStatus.valueOf(sup) != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "requestBillingBy error. not support." + sup);
//            return false;
//        }
//        if (null == act || act.isFinishing()) {
//            return false;
//        }
//        Bundle bundle = mService.getBuyIntent(3, appContext.getPackageName(), sku,
//        BillingClient.SkuType.INAPP, payload);
//        PendingIntent intent = bundle.getParcelable(RESPONSE_BUY_INTENT);
//        if (null == intent) {
//            return false;
//        }
//        ResultReceiver receiver = new ResultReceiver(null) {
//            @Override
//            protected void onReceiveResult(int resultCode, Bundle resultData) {
//                Intent data = resultData.getParcelable(RESPONSE_DATA_INTENT);
//                handleActivityResult(resultCode, data);
//            }
//        };
//        GPInAppBillingActivity.launch(act, receiver, intent);
//        return true;
//    }
//
//    /**
//     * 获取已经拥有的
//     *
//     * @return
//     * @throws RemoteException
//     * @throws JSONException
//     */
//    private List<PurchaseInfo> getPurchases() throws RemoteException {
//        List<PurchaseInfo> purchases = new ArrayList<>();
//        if (null == mService || appContext == null) {
//            RLog.error("GpPayEngine", "getPurchases error. service is not alive.");
//            return purchases;
//        }
//        int sup = mService.isBillingSupported(3, appContext.getPackageName(), BillingClient.SkuType.INAPP);
//        if (GPInAppBillingStatus.valueOf(sup) != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getPurchases error. not support." + sup);
//            return purchases;
//        }
//        Bundle bundle = mService.getPurchases(3, appContext.getPackageName(), BillingClient.SkuType.INAPP, null);
//        int ret = bundle.getInt(RESPONSE_CODE);
//        GPInAppBillingStatus status = GPInAppBillingStatus.valueOf(ret);
//        if (status != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getPurchases error." + status.getMessage());
//            return purchases;
//        }
//        ArrayList<String> skus = bundle.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
//        ArrayList<String> data = bundle.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
//        ArrayList<String> sign = bundle.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
//        if (null == skus || skus.isEmpty() || null == data || data.isEmpty() || null == sign || sign.isEmpty()) {
//            return purchases;
//        }
//        PurchaseInfo purchase;
//        int len = skus.size();
//        for (int i = 0; i < len; i++) {
//            //不需要回调
//            purchase = new PurchaseInfo(data.get(i), sign.get(i), false);
//            purchases.add(purchase);
//        }
//        return purchases;
//    }
//
//    private List<PurchaseInfo> getHistoryPurchases() throws RemoteException {
//        List<PurchaseInfo> purchases = new ArrayList<>();
//        if (null == mService) {
//            RLog.error("GpPayEngine", "getPurchases error. service is not alive.");
//            return purchases;
//        }
//        int sup = mService.isBillingSupported(6, appContext.getPackageName(), BillingClient.SkuType.INAPP);
//        if (GPInAppBillingStatus.valueOf(sup) != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getPurchases error. not support." + sup);
//            return purchases;
//        }
//        Bundle bundle = mService.getPurchaseHistory(6, appContext.getPackageName(),
//        BillingClient.SkuType.INAPP, null, null);
//        int ret = bundle.getInt(RESPONSE_CODE);
//        GPInAppBillingStatus status = GPInAppBillingStatus.valueOf(ret);
//        if (status != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getPurchases error." + status.getMessage());
//            return purchases;
//        }
//        ArrayList<String> skus = bundle.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
//        ArrayList<String> data = bundle.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
//        ArrayList<String> sign = bundle.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
//        if (null == skus || skus.isEmpty() || null == data || data.isEmpty() || null == sign || sign.isEmpty()) {
//            return purchases;
//        }
//        PurchaseInfo purchase;
//        int len = skus.size();
//        for (int i = 0; i < len; i++) {
//            //不需要回调
//            purchase = new PurchaseInfo(data.get(i), sign.get(i), false);
//            purchases.add(purchase);
//        }
//        return purchases;
//    }
//
//    /**
//     * 消费商品
//     *
//     * @param token
//     */
//    public void consumePurchase(String token) throws RemoteException {
//        if (null == token) {
//            RLog.error("GpPayEngine", "consumePurchase error. wrong args.");
//            return;
//        }
//        if (null == mService || appContext == null) {
//            RLog.error("GpPayEngine", "consumePurchase error. service is not alive.");
//            return;
//        }
//        int sup = mService.isBillingSupported(3, appContext.getPackageName(), BillingClient.SkuType.INAPP);
//        if (GPInAppBillingStatus.valueOf(sup) != GPInAppBillingStatus.OK) {
//            RLog.error("GpPayEngine", "getPurchases error. not support." + sup);
//            return;
//        }
//        int response = mService.consumePurchase(3, appContext.getPackageName(), token);
//        RLog.error("GpPayEngine", "consumePurchase." + GPInAppBillingStatus.valueOf(response).getMessage());
//    }
//
//    enum EngineStatus {
//        ENGINE_START, ENGINE_STOP, ENGINE_BUSY
//    }
//}
