package com.yy.mobile.framework.revenue.gppay;

/**
 * Created by ouyangshaocong on 2018/7/19.
 * https://developer.android.com/reference/com/android/billingclient/api/BillingClient.BillingResponse.html
 * 1. 初始化失败，错误码:3，这是支付环境问题。
 *
 * 有以下可能：用的是模拟器，三件套版本太旧，应用的支付环境没配置(接入谷歌服务，支付权限)，vpn地域不支持。
 *
 * 解决方法：a.先验证环境。在商店下载一个有内购的应用，看能否进行内购。b.如果别人的能进行内购之后，再次测试你的应用，看是否正常，来确认应用的支付环境是否正常。
 *
 * 2. 能够查询价格，但无法购买，提示"商品无法购买"之类。
 *
 * 这是基础配置问题，有以下可能：版本号与线上版本不对应，不是测试账号(大概率)，商品状态有问题不支持支付，现在有人反映签名也需要对应。
 *
 * 3. 能够查询价格，但无法调起支付都没有弹窗，错误码:3，报错：Error:In-app billing error: Null data in IAB activity resul。
 *
 * 原因是没有给Google play商店弹窗权限，国内很多手机都有弹窗权限管理，特别是小米，如果没允许，是不会有任何提示，并且拦截了的。(这个问题在新版的gp商店已经不存在）
 *
 * 4. 支付提示成功，但却走onQueryFail回调，并且返回的商品列表为null。
 *
 * 这是因为你调错了方法，记得purchaseInApp是内购的，purchaseSubs是订阅的。查询的时候同理。另外查询的时候报错，很有可能是你setSKUS的时候传了一个空字符串，而不是空数组。
 *
 * 内购对支付环境的要求很高，最好测试的时候找那些绑定了信用卡的账号来测试，多换几台手机来测，不然有可能什么都不提示，直接失败。另外就是翻墙，应用的包名、版本号需要对应，商品id不要有错。
 *
 * 查询已购买的商品列表时，googleplay返回的是其本地缓存的内容，具体什么时候会联网更新，还有更新频率，这个不是很清楚，反正知道不是实时的就行，不会很影响使用。例如订阅，如果说是12:00:00就到期了，但你12:10:00上去或者还能查到记录，但再过一会肯定恢复正常。
 *
 * 万能的测试方法： a. 确认环境正常：下载一个需要内购的app进行测试，环境不正常则更新三件套，或者找一台正常真机来测。
 * b.确认商品正常：找一个走通了购买流程的项目，将自己的信息替换上去，看是否正常。
 * 不正常则看是否已经是测试账号登录了，商品是否处于能够支付的状态。
 * c.确认代码正常: 找一个能够购买的项目，将这个项目的信息替换上去，看是否正常。
 * 代码问题的概率比较小，因为支付只要包名和版本号对应就行了，当然，接入谷歌服务和设置支付权限也是必须的。
 */
public enum GPInAppBillingStatus {
    SERVICE_DISCONNECTED(-1, "Google Store Service链接断开，连接失败"),
    FEATURE_NOT_SUPPORTED(-2, "设备当前的Google Store不支持此功能"),
    OK(0, "成功"),
    USER_CANCELED(1, "用户按下了“返回”或者取消了对话"),
    SERVICE_UNAVAILABLE(2, "网络连接丢失"),
    // 不能链接到Google Play，包括缺失，无网络，没登录
    BILLING_UNAVAILABLE(3, "Billing API 版本不受所请求类型的支持(一般支付环境问题)"),
    ITEM_UNAVAILABLE(4, "请求的商品不可以购买"),
    DEVELOPER_ERROR(5, "向 API 提供的参数无效! 此错误也可能说明未在 Google Play " +
            "中针对应用内购买结算正确签署或设置应用，或者应用在其清单中不具备所需的权限。"),
    ERROR(6, "API 操作期间发生致命错误"),
    ITEM_ALREADY_OWNED(7, "由于已经拥有该商品，购买失败"),
    ITEM_NOT_OWNED(8, "由于未拥有该商品，消耗失败"),

    SERVICE_TIMEOUT(101, "谷歌服务连接超时"),

    PAY_DIALOG_EXIT_WITHOUT_CALLBACK(102, "支付对话框关闭，但是没有支付结果回调"),

    ERROR_PURCHASES_INFO_EMPTY(103, "查询不到对应商品信息"),

    UNKNOWN(-100, "未知状态");

    final int code;
    final String message;

    /**
     * 构造函数
     *
     * @param code
     * @param msg
     */
    GPInAppBillingStatus(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    /**
     * 通过code获取对应状态
     *
     * @param code
     * @return
     */
    public static GPInAppBillingStatus valueOf(int code) {
        switch (code) {
            case -1:
                return SERVICE_DISCONNECTED;
            case -2:
                return FEATURE_NOT_SUPPORTED;
            case 0:
                return OK;
            case 1:
                return USER_CANCELED;
            case 2:
                return SERVICE_UNAVAILABLE;
            case 3:
                return BILLING_UNAVAILABLE;
            case 4:
                return ITEM_UNAVAILABLE;
            case 5:
                return DEVELOPER_ERROR;
            case 6:
                return ERROR;
            case 7:
                return ITEM_ALREADY_OWNED;
            case 8:
                return ITEM_NOT_OWNED;
            default:
                return UNKNOWN;
        }
    }

    /**
     * 返回状态描述
     *
     * @return
     */
    public String getMessage() {
        return message;
    }

    /**
     * 返回错误码
     *
     * @return
     */
    public int getCode() {
        return code;
    }
}
