package com.yy.mobile.framework.revenue.gppay;

import android.content.Context;
import android.content.SharedPreferences;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PayTokenCache {
    private final static String TAG = "PayTokenCache";
    private final static String SP_NAME_PAYTOKEN = "SP_NAME_PT";
    private final static String SP_KEY_PAYTOKEN = "SP_KEY_PT_";
    private final static String SPLIT = "##";
    /**
     * 支付完成保存token
     * @param productId
     * @param info
     */
    public static void savePayToken(Context context, String productId, PurchaseInfo info) {
        try {
            RLog.info(TAG, "---savePayToken ** " + info.data + ", " + info.signature);
            String value = info.data + SPLIT + info.signature;
            // 本地保存token
            SharedPreferences sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, Context.MODE_PRIVATE);
            sp.edit().putString(SP_KEY_PAYTOKEN + productId, value)
                    .commit();
            RLog.info(TAG, "---savePayToken >> " + value);
        } catch (Exception e) {
            RLog.error(TAG,
                    String.format(Locale.ENGLISH,
                            "---savePayToken save error = %s",
                            e.toString()));
            e.printStackTrace();
        }
    }

    public static List<PurchaseInfo> readPayToken(Context context) {
        List<PurchaseInfo> list = new ArrayList<PurchaseInfo>();
        SharedPreferences sp = null;
        try {
            RLog.info(TAG, "---readPayToken **");
            // 本地保存token
            sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, Context.MODE_PRIVATE);
        } catch (Exception e) {
            RLog.error(TAG,
                    String.format(Locale.ENGLISH,
                            "---readPayToken read error = %s",
                            e.toString()));
            e.printStackTrace();
        }
        if (sp != null) {
            Map<String, ?> allRecord = sp.getAll();
            for (Map.Entry<String, ?> entry : allRecord.entrySet()) {
                try {
                    String value = (String) entry.getValue();
                    RLog.info(TAG, "---readPayToken << " + value);
                    String[] values = value.split(SPLIT);
                    String data = values[0];
                    String signature = values[1];
                    PurchaseInfo purchaseInfo = new PurchaseInfo(data, signature);
                    list.add(purchaseInfo);
                } catch (Exception e) {
                    RLog.error(TAG,
                            String.format(Locale.ENGLISH,
                                    "---readPayToken read - error = %s",
                                    e.toString()));
                }
            }
        }
        return list;
    }

    public static void removePayToken(Context context, String orderId) {
        RLog.error(TAG, "---removePT " + orderId);
        if (context != null && orderId != null && !orderId.isEmpty()) {
            SharedPreferences sp = context.getSharedPreferences(SP_NAME_PAYTOKEN, Context.MODE_PRIVATE);
            sp.edit().remove(SP_KEY_PAYTOKEN + orderId).commit();
        }
    }

    //-----------------------------------
    public static String getProductId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("productId");
                if (tagObject == null) {
                    tagObject = "";
                }
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --productId--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , orderId =%s"
                        , data, tagObject));

        return tagObject;
    }

    public static String getPayLoad(Context context, String productId) {
        if (context == null) {
            RLog.error(TAG,
                    String.format(Locale.ENGLISH,
                            "---reportPurchase read error, context is null"));
            return "";
        }
        try {
            // 获取本地保存的payload
            final String SP_NAME_PAYLOAD = "SP_NAME_TMP";
            final String SP_KEY_PAYLOAD = "SP_KEY_PL_" + productId;
            SharedPreferences sp = context.getSharedPreferences(SP_NAME_PAYLOAD, Context.MODE_PRIVATE);

            RLog.info(TAG, "readPay - key:" + SP_KEY_PAYLOAD);

            return sp.getString(SP_KEY_PAYLOAD, "");
        } catch (Exception e) {
            RLog.error(TAG,
                    String.format(Locale.ENGLISH,
                            "---reportPurchase read error = %s",
                            e.toString()));
            e.printStackTrace();
        }
        return "";
    }

    public static String getPayLoad(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error(TAG,
                            String.format(Locale.ENGLISH,
                                    "data parser fail --getPayLoad =null "));
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getPayLoad--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser result ---PayCallbackProxy " +
                                "data =%s , getPayLoad =%s"
                        , data, tagObject));

        return tagObject;
    }

    public static String getCHOrderId(String data) {
        String tagObject = "";

        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("chOrderId");
                if (tagObject == null) {
                    tagObject = "";
                }
            } catch (JSONException e) {
                e.printStackTrace();
                RLog.error(TAG,
                        String.format(Locale.ENGLISH,
                                "data parser fail --getCHOrderId--PayCallbackProxy " +
                                        "data =%s , Exception =%s"
                                , data, e.getMessage()));
            }
        }

        RLog.info(TAG,
                String.format(Locale.ENGLISH,
                        "data parser success ---PayCallbackProxy " +
                                "data =%s , chorderId =%s"
                        , data, tagObject));

        return tagObject;
    }
}
