package com.yy.mobile.framework.revenue.gppay;

import android.app.Activity;
import android.content.Context;

import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;

import java.util.List;

/**
 * Created by Administrator on 2019/1/3.
 * Describe: Nothing.
 */

@SuppressWarnings("javadoc")
public interface IGpPayEngine {

    /**
     * 启动Engine
     *
     * @return
     */
    boolean startEngine(Context context);

    /**
     * 关闭startEngine
     * 本来跟GP的交互应该是在内部维护的,
     * 不过这里因为整个支付流程依赖了业务后台.
     * 所以这里对外暴露了start & stop接口.用以外部来关闭掉GP的链接.
     */
    void stopEngine();


    /**
     * 向GP发起一个支付请求.
     *
     * @param request
     * @param callback
     */
    void sendRequest(GpRequest request, IPayCallback<PurchaseInfo> callback);

    /**
     * GP内购的最后一步,消费凭证.
     *
     * @param context
     * @param data
     * @param sign
     */
    void consume(Context context, String data, String sign);

    /**
     * 查询是否有未完成的支付订单.
     *
     * @param act
     * @return
     */
    boolean hasHangPayJob(Activity act, IResult<List<PurchaseInfo>> iResult);
}
