package com.yy.platform.baseservice.threads;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public final class ThreadManager {
    // UI线程
    private static Handler sManinHandler;

    private static Handler sSubHandler;
    private static HandlerThread sSubThread;

    public static synchronized void init() {
        sManinHandler = new Handler(Looper.getMainLooper());

        sSubThread = new HandlerThread("ServiceSDKThread");
        sSubThread.start();
        sSubHandler = new Handler(sSubThread.getLooper());
    }

    public static synchronized void deInit() {
        sSubThread.quitSafely();
        sSubThread = null;
        sSubHandler = null;
    }

    /**
     * 取得UI线程Handler
     *
     * @return
     */
    public static Handler getMainHandler() {
        return sManinHandler;
    }

    public static synchronized void executeOnMainThread(Runnable run) {
        getMainHandler().post(run);
    }

    /**
     * 在副线程执行. <br>
     * 可以执行本地文件读写等比较快但不能在ui线程执行的操作.<br>
     * <b>此线程禁止进行网络操作.如果需要进行网络操作. 请使用NETWORK_EXECUTOR</b>
     *
     * @return
     */
    public static synchronized void executeOnSubThread(Runnable run) {
        if (sSubHandler == null) {
            new Thread(run).start();
        } else {
            sSubHandler.post(run);
        }
    }
    public static synchronized void executeOnSubNewThread(Runnable run) {
        new Thread(run).start();
    }
    public static synchronized void executeOnSubThread(final Runnable run, long delay) {
        if (sSubHandler == null) {
            sManinHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    new Thread(run).start();
                }
            }, delay);
        } else {
            sSubHandler.postDelayed(run, delay);
        }
    }
}
