package com.yy.platform.baseservice.statis;

import android.net.NetworkInfo;

import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.notify.ReportItem;
import com.yy.platform.baseservice.notify.ReportServiceAct;
import com.yy.platform.baseservice.notify.ReportServiceActRtt;
import com.yy.platform.baseservice.notify.ReportServiceCount;
import com.yy.platform.baseservice.notify.ReportServiceRtt;
import com.yy.platform.baseservice.storage.ShareStore;
import com.yy.platform.baseservice.threads.ThreadManager;

public final class StatisReporter {

    private static StatisReporter sInstance = null;
    private boolean mDefaultHiidoApi = true;
    private IChannelListener.IServiceHiidoMetricsStatisApi mMetricsHiidoApi = null;
    private long mStatisUid = 0L;
    private int mABTest = -1;
    private YYServiceCore.BroadcastReceiverImpl mNetworkUtil = null;

    public synchronized static StatisReporter instance() {
        if (sInstance == null) {
            sInstance = new StatisReporter();
        }
        return sInstance;
    }

    private StatisReporter() {
    }

    public void init(int abTest, String reportRegion,
                     YYServiceCore.BroadcastReceiverImpl networkUtil) {
        mNetworkUtil = networkUtil;
        mABTest = abTest;

        mMetricsHiidoApi = new HiidoApiImpl(reportRegion);
        mDefaultHiidoApi = true;
    }

    public void deInit() {
        mMetricsHiidoApi = null;
        mDefaultHiidoApi = true;
    }

    public void setMetricsHiidoApi(IChannelListener.IServiceHiidoMetricsStatisApi api) {
        // if (api != null) {
        //     mMetricsHiidoApi = api;
        //     mDefaultHiidoApi = false;
        // }
    }

    public void setStatisUid(long uid) {
        mStatisUid = uid;
    }

    public long getStaticUid() {
        return mStatisUid;
    }

    private void reportActWithNetwork(ReportServiceAct reportItem, int nt, long realt,
                                      String hdid, long tid) {
        int ns = mNetworkUtil.getNetWorkState();
        final int ncn = mNetworkUtil.getNetworkChangedCount();
        final long nct = mNetworkUtil.getLastNetworkChangedTs();
        YYServiceCore.log("[" + tid + "] report act=" + reportItem.mAct + ",rdt=" + realt + ",nt=" + nt + ",ns=" + ns);
        for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
            item.mStringFields.put("hdid", hdid);
            item.mIntFields.put("ab", mABTest);
            item.mIntFields.put("nt", nt);
            item.mIntFields.put("ns", ns);
            item.mIntFields.put("ncn", ncn);

            item.mLongFields.put("nct", nct);
            item.mLongFields.put("rdt", realt);

            mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                    item.mIntFields, item.mLongFields,
                    item.mStringFields);
        }
    }

    private void reportMetricWithNetwork(ReportServiceRtt reportItem, long realt) {
        int ns = mNetworkUtil.getNetWorkState();
        if (ns == NetworkInfo.State.CONNECTED.ordinal()) {
            if (mDefaultHiidoApi) {
                ((HiidoApiImpl) mMetricsHiidoApi).reportReturnCodeTemporary(realt, reportItem.mScode,
                        reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
            } else {
                mMetricsHiidoApi.reportReturnCode(reportItem.mScode, reportItem.mRttUri,
                        reportItem.mRtt, reportItem.mRttCode);
            }
        }
    }

    public void onServiceAct(final ReportServiceAct reportItem) {
        final String hdid = ShareStore.INSTANCE.getHdId();
        final long realt = System.currentTimeMillis() / 1000;
        //及时的上报用executeOnSubNewThread，防止sSubHandler处理日志过多被阻塞
        if ("ystinit".equals(reportItem.mAct)) {
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    try {
                        //实时获取一次
                        int nt = mNetworkUtil.checkCurrentNetwork();
                        final long realt = System.currentTimeMillis() / 1000;
                        reportActWithNetwork(reportItem, nt, realt, hdid, tid);
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else if ("ystapfsucc".equals(reportItem.mAct)
                || "ystapffail".equals(reportItem.mAct)) {
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    try {
                        YYServiceCore.log("[" + tid + "] report act=" + reportItem.mAct + ",rdt=" + realt);
                        for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
                            item.mStringFields.put("uuid", ShareStore.INSTANCE.getUUID());
                            item.mLongFields.put("rdt", realt);
                            mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else {
            ThreadManager.executeOnSubThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    try {
                        for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
                            item.mStringFields.put("hdid", hdid);
                            item.mIntFields.put("ab", mABTest);
                            YYServiceCore.log("[" + tid + "] report act=" + reportItem.mAct
                                    + ",code=" + item.mIntFields.get("code") + ",num=" + item.mIntFields.get("num"));
                            mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act ex:" + e.getMessage());
                        return;
                    }
                }
            });
        }
    }

    public void onServiceActRtt(final ReportServiceActRtt reportActItem) {
        final String hdid = ShareStore.INSTANCE.getHdId();
        final long realt = System.currentTimeMillis() / 1000;
        if ("ystap".equals(reportActItem.mAct.mAct)
                || "ystsvclogin".equals(reportActItem.mAct.mAct)) {
            //分开2个线程报，不然网络不好时候上报Act会滞后
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    try {
                        reportMetricWithNetwork(reportItem, realt);
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    try {
                        //实时获取一次
                        int nt = mNetworkUtil.checkCurrentNetwork();
                        reportActWithNetwork(reportActItem.mAct, nt, realt, hdid, tid);
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else if ("ystapfsucc".equals(reportActItem.mAct.mAct)
                || "ystapffail".equals(reportActItem.mAct.mAct)) {
            //分开2个线程报，不然网络不好时候上报Act会滞后
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    try {
                        reportMetricWithNetwork(reportItem, realt);
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
            ThreadManager.executeOnSubNewThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    try {
                        YYServiceCore.log("[" + tid + "] report act rtt=" + reportActItem.mAct.mAct + ",rdt=" + realt);
                        for (ReportItem.ServiceActKeyItem item : reportActItem.mAct.mKeyFields) {
                            item.mStringFields.put("uuid", ShareStore.INSTANCE.getUUID());
                            item.mLongFields.put("rdt", realt);
                            mMetricsHiidoApi.reportStatisticContentTemporary(reportActItem.mAct.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else if ("ystapdelay".equals(reportActItem.mAct.mAct)) {
            ThreadManager.executeOnSubThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    try {
                        reportMetricWithNetwork(reportItem, realt);

                        YYServiceCore.log("[" + tid + "] report act rtt=" + reportActItem.mAct.mAct + ",rdt=" + realt);
                        for (ReportItem.ServiceActKeyItem item : reportActItem.mAct.mKeyFields) {
                            mMetricsHiidoApi.reportStatisticContentTemporary(reportActItem.mAct.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else if ("ystrpc".equals(reportActItem.mAct.mAct)) {
            ThreadManager.executeOnSubThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    try {
                        reportMetricWithNetwork(reportItem, realt);

                        //量较多，不实时检测
                        int nt = mNetworkUtil.getNetWorkType();
                        reportActWithNetwork(reportActItem.mAct, nt, realt, hdid, tid);
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
        } else {
            ThreadManager.executeOnSubThread(new Runnable() {
                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    try {
                        reportMetricWithNetwork(reportItem, realt);

                        YYServiceCore.log("[" + tid + "] report act rtt=" + reportActItem.mAct.mAct);
                        for (ReportItem.ServiceActKeyItem item : reportActItem.mAct.mKeyFields) {
                            item.mStringFields.put("hdid", hdid);
                            item.mIntFields.put("ab", mABTest);

                            mMetricsHiidoApi.reportStatisticContentTemporary(reportActItem.mAct.mAct,
                                    item.mIntFields, item.mLongFields,
                                    item.mStringFields);
                        }
                    } catch (Throwable e) {
                        YYServiceCore.log("[" + tid + "] report act rtt ex:" + e.getMessage());
                        return;
                    }
                }
            });
        }
    }

    public void onServiceRtt(final ReportServiceRtt reportItem) {
        //目前只有rpc会报这个，rpc量比较大，不能用NewThread
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                long tid = Thread.currentThread().getId();
                try {
                    if (mNetworkUtil.getNetWorkState() != NetworkInfo.State.CONNECTED.ordinal()) {
                        YYServiceCore.log("[" + tid + "] report rtt not network connected:" + reportItem.mRttUri);
                        return;
                    }
                    mMetricsHiidoApi.reportReturnCode(reportItem.mScode,
                            reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                } catch (Throwable e) {
                    YYServiceCore.log("[" + tid + "] report rtt ex:" + e.getMessage());
                    return;
                }
            }
        });
    }

    public void onServiceCount(final ReportServiceCount reportItem) {
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                long tid = Thread.currentThread().getId();
                try {
                    if (mNetworkUtil.getNetWorkState() != NetworkInfo.State.CONNECTED.ordinal()) {
                        YYServiceCore.log("[" + tid + "] report count not network connected:" + reportItem.mCountUri);
                        return;
                    }
                    for (int i = 0; i < reportItem.mCountImtems.length; i++) {
                        mMetricsHiidoApi.reportCount(reportItem.mScode, reportItem.mCountUri,
                                reportItem.mCountImtems[i].mCountName,
                                reportItem.mCountImtems[i].mCount);
                    }
                } catch (Throwable e) {
                    YYServiceCore.log("[" + tid + "] report count ex:" + e.getMessage());
                    return;
                }

            }
        });
    }
}
