﻿//
// Created by HUTAO on 2017/6/30.
//

#ifndef YYPROTO_PROTOTASKTHREAD_H
#define YYPROTO_PROTOTASKTHREAD_H

#include "commondefine.h"
#include "ITaskThread.h"
#include "mutex.h"
#include "LogFile.h"
#include "basemod.h"

NAMESPACE_BASEMOD_BEGIN
class ProtoTaskThreadImp : public ITaskThread
{
public:
	struct TaskContext
	{
		IProtoTask*	task;
		uint64_t	last;
		uint64_t	interval;
		bool		removed;
	};

public:
	ProtoTaskThreadImp(Log* log,IBaseMod* p);
	~ProtoTaskThreadImp();

public:
	void 	run();
	void	onTasks();
	void	onDelayTasks();
	void    onHPTask(); //High Priority task

	void	post(IProtoTask* task);
	void	post(IProtoTask* task, uint32_t delay);

	void	stop();
	void	remove(IProtoTask* task);
	void	clear();
	void	start();


private:
	void    setHPEvent();
	void    resetHPEvent();

private:
	IBaseMod* m_pBaseMod;
	Log*	   m_pLog;
	AdaptLock*     m_pMutex;
	AdaptLock*     m_pDelayMutex;
	AdaptLock*     m_pHPMutex;
	AdaptLock*     m_ExitMutex;

#ifdef _WIN32
	HANDLE			m_hThread;
#else
	pthread_t       m_hThread;
#endif

	std::vector<IProtoTask*>	mTasks;
	std::deque<IProtoTask*>     mHPTask;
	std::deque<IProtoTask*>		mSaveTasks;
	std::deque<IProtoTask*>		mOnExitTask;
	std::deque<IProtoTask*>		mOnStartTask;

	std::vector<TaskContext>	mDelayTasks;

	volatile bool            m_bExit;
#if defined(_WIN32)
	HANDLE          m_event;
#else
	int             mPipeFd[2];
#endif
	uint64_t        mLastTimerval;

	int				m_bStarted;
};
NAMESPACE_BASEMOD_END
#endif //YYPROTO_PROTOTASKTHREAD_H
