package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.NumberUtils;
import com.yy.platform.baseservice.marshal.ProtoPacket;

public abstract class AbstractTask<T extends ProtoPacket> extends ProtoPacket {

    protected IRPCChannel.RPCCallback<T> mCallback;
    protected IRPCChannel.RPCCallbackWithTrace<T> mCallbackWithTrace;
    protected T mSrvRes;

    protected int mRequestId;
    protected TaskOptions.TaskOption mOptions;
    protected Handler mScheduler;

    public AbstractTask(long uri, int reqId, IRPCChannel.RPCCallback<T> callback,
                        Bundle options, Handler scheduler) {
        setUri(NumberUtils.longToUint32ForCpp(uri));

        mRequestId = reqId;
        mOptions = new TaskOptions.TaskOption(options);

        mCallback = callback;
        mScheduler = scheduler;
    }

    public AbstractTask(long uri, int reqId, IRPCChannel.RPCCallbackWithTrace<T> callback,
                        Bundle options, Handler scheduler) {
        setUri(NumberUtils.longToUint32ForCpp(uri));

        mRequestId = reqId;
        mOptions = new TaskOptions.TaskOption(options);

        mCallbackWithTrace = callback;
        mScheduler = scheduler;
    }

    @Override
    public byte[] marshall() {
        pushInt(mRequestId);
        mBuffer = pushMarshallable(mOptions);
        return super.marshall();
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
    }

    // public abstract int SrvResCode();

    // public abstract void onResponse(final int requestId, final int sdkResCode);

    public abstract void onResponseSuccess(final int requestId, final int sdkResCode);

    public abstract void onResponseFail(final int requestId, final int sdkResCode);
}
