package com.yy.platform.baseservice.notify;

import com.yy.platform.baseservice.marshal.NumberUtils;
import com.yy.platform.baseservice.marshal.ProtoPacket;

public class BroadCastV2Notify extends ProtoPacket {
    public long mUid;
    public long mAppid; // [必填] 应用标识
    public String mUserGroup; // [必填] 广播组

    public String mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
    public String mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
    public String mProtoType; // [可选]协议类型
    public byte[] mData; // [必填]业务包

    // 多路去重
//    public long mServerId; // 发起广播进程标识
//    public long mSeqId; // 序号
    public String mTraceId;
    public static final long URI = 22;

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
        mUid = popInt64();
        mAppid = NumberUtils.uint32ToLong(popInt());
        mUserGroup = popString16("UTF-8");
        mServiceName = popString16("UTF-8");
        mFunctionName = popString16("UTF-8");
        mProtoType = popString16("UTF-8");
        mData = popBytes();

//        mServerId = popInt64();
//        mSeqId = popInt64();
        mTraceId = popString16("UTF-8");
    }
}

