package com.yy.platform.baseservice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.util.Log;

import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.platform.baseservice.profile.DefaultServiceProfileFactory;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.statis.StatisReporter;
import com.yy.platform.baseservice.storage.ShareStore;
import com.yy.platform.baseservice.threads.ThreadManager;
import com.yy.platform.baseservice.utils.LoadLibraryUtils;

public class YYServiceCore {
    public static String TAG = "YYSDK_S";

    private static boolean loadLibrary(Context context) {
//        if (Build.VERSION.SDK_INT <= 19) {
//            if(!LoadLibraryUtils.loadLibrary(context,"gnustl_shared"))
//            {
//                Log.e(TAG,"<=19 load gnustl_shared failed");
//                YYServiceCore.log("<=19 load gnustl_shared failed");
//                return false;
//            }
//        }
        LoadLibraryUtils.loadLibrary(context, "gnustl_shared");

//        YYAccessTransJni.nativeLogCallback(0,null);//暂时不依赖它的java代码//解决onload里面使用了YYAccessTransJni这个Class
        if (!LoadLibraryUtils.loadLibrary(context, "YYAccessTransSDK")) {
            Log.e(TAG, "load YYAccessTransSDK failed");
            YYServiceCore.log("load YYAccessTransSDK failed");
            return false;
        }
        if (!LoadLibraryUtils.loadLibrary(context, "yyservicesdk")) {
            Log.e(TAG, "load yyservicesdk failed");
            YYServiceCore.log("load yyservicesdk failed");
            return false;
        }

        return true;
    }

    private static HttpDnsService mGSLB = null;
    private static DnsResultInfo mDnsResult = null;
    private static Channel mServiceChannel = null;
    private static Channel mDeInitChannel = null;
    private static int mInitState = -1;

    private static Context mAppContext = null;
    private static ServiceProfileFactory gProfile = null;

    private static Handler mMainHandler = null;

    private static LogProfile.ILog mLogger = new DefaultLogger();

    private static YYServiceCore sInstance = new YYServiceCore();

    private BroadcastReceiverImpl mReceiver = null;

    private YYServiceCore() {
        mReceiver = new BroadcastReceiverImpl();
    }

    private static boolean sUseTrans = true;

    public synchronized static void setUseTrans(boolean useTrans) {
        sUseTrans = useTrans;
    }

    private static int sABTest = 1;

    /**
     * 设置ABTest 方案
     * 固化ap链接策略B方案为默认方案abtest=0，gslb的新实验abtest=1
     *
     * @param abTest
     */
    public synchronized static void setABTest(int abTest) {
        sABTest = abTest;
    }

    private static String sReportRegion = "";

    /**
     * 设置指定上报海度服务域名地区,
     * 取值ISO 3166-1 {https://aiezu.com/article/46.html}标准国家代码（2位或3位）,比如CN
     *
     * @param reportRegion
     */
    public synchronized static void setReportRegion(String reportRegion) {
        sReportRegion = reportRegion;
        if (sReportRegion == null) {
            sReportRegion = "";
        }
    }

    /**
     * App初始化SDK通道，不初始化GSLB，由使用方优先初始化GSLB实例，一般公司内部使用
     *
     * @param appContext     Application上下文
     * @param appid          接入Service服务申请的AppId
     * @param region         大多数给null即可就近接入Service ap，
     *                       如果需要指定区域请与Service后台确认，取值于{https://zh.wikipedia.org/wiki/ISO_3166-1}中的二位代码
     * @param profileFactory 日志配置和测试环境配置，
     *                       LogProfile不能给null，提供给App层搜集log
     *                       ChannelProfile给null则默认链接正式环境
     * @param listener       通道的连通状态监听器，可及时感知到连接的可用性，
     *                       可根据状态描述采取进一步措施，比如提醒用户检查网络、绑定帐号
     * @return Service通道实例
     */
    public synchronized static IChannel init(Context appContext,
                                             long appid,
                                             String region,
                                             ServiceProfileFactory profileFactory,
                                             IChannelListener.IChannelStatusNotify listener) {
        if (mServiceChannel == null) {
            mInitState = 0;

            mAppContext = appContext;
            sInstance.mReceiver.setAppContext(mAppContext);
            ThreadManager.init();

            mMainHandler = ThreadManager.getMainHandler();

            ShareStore.INSTANCE.init(mAppContext, appid);
            StatisReporter.instance().init(sABTest, sReportRegion, sInstance.mReceiver);

            //如果未先初始化GSLB 实例，则崩溃，目前只用这种在开发期间暴露问题来避免错误的初始化GSLB SDK
            mGSLB = HttpDnsService.getService();
            dnsAsync();

            if (profileFactory == null) {
                gProfile = new DefaultServiceProfileFactory(mAppContext);
            } else {
                gProfile = profileFactory;
            }
            int logPrinter = LogProfile.Printer.SdkToAppInstallDir;
            String logPath = "";
            String testIp = "";
            int testPort = 0;
            LogProfile.ILog logger = null;
            boolean isLogCat = false;
            if (gProfile.logProfile() != null) {
                if (gProfile.logProfile().getLog() != null) {
                    logPrinter = LogProfile.Printer.App;
                    logger = gProfile.logProfile().getLog();
                } else if (gProfile.logProfile().logPath() != null && (!gProfile.logProfile().logPath().isEmpty())) {
                    logPrinter = LogProfile.Printer.SdkToAppProvideDir;
                    logPath = gProfile.logProfile().logPath();
                }
                isLogCat = gProfile.logProfile().isLogCat();
            }
            if (logPrinter == LogProfile.Printer.SdkToAppInstallDir) {
                logPath = mAppContext.getFilesDir().getAbsolutePath() + DefaultServiceProfileFactory.sDefLogDir;
            }

            if (gProfile.channelProfile() != null
                    && (gProfile.channelProfile().ipAddress() != null)) {
                testIp = gProfile.channelProfile().ipAddress();
            }
            if (gProfile.channelProfile() != null) {
                testPort = gProfile.channelProfile().ipPort();
            }
            if (logger != null) {
                mLogger = logger;
            }
            byte[] appName = getAppName(mAppContext).getBytes();
            byte[] appVer = getAppVersion(mAppContext).getBytes();

            byte[] sdkVer = version().getBytes();

            byte[] area = (region == null) ? "".getBytes() : region.getBytes();

            //加载库
            //loadLibrary(appContext);
            boolean loadSuccess = loadLibrary(appContext);
            if (!loadSuccess) {
                mServiceChannel = createChannel(appid, 0, logger, false);
            } else {
                try {
                    sInstance.mReceiver.getNetWorkType();
                    int status = sInstance.mReceiver.getNetwork();
                    if (logger != null) {
                        initLibraryLogger(sInstance, appName, appVer, sdkVer, appid, area, status,
                                isLogCat, sUseTrans, sABTest);
                    } else {
                        initLibrary(sInstance, appName, appVer, sdkVer, appid, area, status, logPath.getBytes(),
                                isLogCat, sUseTrans, sABTest);
                    }

                    mServiceChannel = createChannel(appid, status, mLogger, true);
                } catch (Throwable e) {
                    Log.e(TAG, "init yyservicesdk failed");
                    YYServiceCore.log("init yyservicesdk failed");
                    loadSuccess = false;
                    mServiceChannel = createChannel(appid, 0, mLogger, false);
                }
            }

            mServiceChannel.initReport(appid, new String(appName), new String(appVer), new String(sdkVer));

            if (loadSuccess) {
                mServiceChannel.startConnect(testIp, testPort, listener);

                sInstance.mReceiver.registCallback();

            }
            mInitState = 1;
        }
        return mServiceChannel;
    }

    /**
     * App初始化SDK通道并且如果GSLB未初始化则由SDK内部初始化实例，一般给公司外部业务使用需隐藏GSLB
     *
     * @param appContext     Application上下文
     * @param appid          接入Service服务申请的AppId
     * @param region         大多数给null即可就近接入Service ap，
     *                       如果需要指定区域请与Service后台确认，取值于{https://zh.wikipedia.org/wiki/ISO_3166-1}中的二位代码
     * @param profileFactory 日志配置和测试环境配置，
     *                       LogProfile不能给null，提供给App层搜集log
     *                       ChannelProfile给null则默认链接正式环境
     * @param listener       通道的连通状态监听器，可及时感知到连接的可用性，
     *                       可根据状态描述采取进一步措施，比如提醒用户检查网络、绑定帐号
     * @return Service通道实例
     */
    public synchronized static IChannel initWithGSLB(Context appContext,
                                                     long appid,
                                                     String region,
                                                     ServiceProfileFactory profileFactory,
                                                     IChannelListener.IChannelStatusNotify listener) {

        if (mServiceChannel == null) {
            //获取App初始化的gslb单例，没有就创建service sdk的，
            //此时localize 会是空的，对service这边无影响，但如果是业务也要使用GSLB 可能会有影响
            if (HttpDnsService.getService() == null) {
                HttpDnsService.getService(appContext, "servicesdk", null, "", "");
            }
            return init(appContext, appid, region, profileFactory, listener);
        }
        return mServiceChannel;
    }

    /**
     * 反初始化/卸载
     */
    public synchronized static int deInit() {
        if (mInitState < 0) {
            return -1;
        }

        if (initEnd(sInstance)) {
            //init结束才能deInit，防止死锁和SIGSEV
            mInitState = 2;

            deInitLibrary(sInstance);

            releaseChannel();
            StatisReporter.instance().deInit();
            ThreadManager.deInit();
            mInitState = -1;
            return 0;
        }
        return -1;
    }

    private static String getAppName(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            String name = context.getResources().getString(info.labelRes);
            return name == null ? "" : name;
        } catch (Throwable e) {
            return "";
        }
    }

    private static String getAppVersion(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo packageInfo = manager.getPackageInfo(context.getPackageName(), 0);

            return packageInfo.versionName == null ? "" : packageInfo.versionName;
        } catch (Throwable e) {
            return "";
        }
    }

    public static String version() {
        return BuildConfig.BUILD_VERSION;
    }

    //建连接时候就需要HdId 统计
    public byte[] hdid() {
        try {
            byte[] hdid = ShareStore.INSTANCE.getHdId().getBytes();
            return hdid;
        } catch (Throwable e) {
            log("ex:" + e.getMessage());
        }
        return "".getBytes();
    }

    private static void dnsAsync() {
        //启动时候异步解析一次为建立连接做准备
        //"aplbs.service.yy.com"));
        mDnsResult = mGSLB.getIpsByHostAsync(new String("aplbs.service.huanju.cn"));
    }

    public String[] dnsResolve(byte[] host) {
        String[] ips = new String[]{};
        if (mDnsResult == null || (mDnsResult.mIps == null) || (mDnsResult.mIps.length == 0)) {
            DnsResultInfo info = mGSLB.getIpsByHost(new String(host), true);
            if (info != null && (info.mIps != null)) {
                ips = info.mIps;
            }

        } else {
            ips = mDnsResult.mIps;
        }
        //为下次建连接做准备
        mDnsResult = mGSLB.getIpsByHostAsync(new String(host));

        return ips;
    }

    public String[] dnsStoreLoad() {
        return ShareStore.INSTANCE.dnsStoreLoad();
    }

    public int dnsStoreFlush(String[] ips) {
        return ShareStore.INSTANCE.dnsStoreFlush(ips);
    }

    private static class DefaultLogger implements LogProfile.ILog {

        @Override
        public void outputLog(String log) {
            Log.i(TAG, log);
        }
    }

    public static void log(final String msg) {
        ThreadManager.executeOnSubThread(new Runnable() {
            @Override
            public void run() {
                try {
                    mLogger.outputLog(msg);
                } catch (Throwable e) {
                    Log.e(TAG, "ex:" + e.getLocalizedMessage());
                }
            }
        });
    }

    public void nativeLog(final byte[] msg) {
        log(new String(msg));
    }

    /**
     * 提供给其他SDK获取ServiceChannel 实例
     *
     * @return
     */
    public static synchronized IChannel getInstance() {
        if (mServiceChannel == null) {
            //可能也为空的
            return mDeInitChannel;
        }
        return mServiceChannel;
    }

    private static Channel createChannel(long appId, int netStatus,
                                         LogProfile.ILog loger, boolean loadSuccess) {
        Channel channel = new Channel(mMainHandler, loger, loadSuccess);
        if (loadSuccess) {
            newChannel(channel, netStatus);
        }

        return channel;
    }

    private static int releaseChannel() {
        if (mServiceChannel == null) {
            return -1;
        }
        mServiceChannel.release();
        mServiceChannel = null;
        mDeInitChannel = new Channel(mMainHandler, mLogger);
        return 0;
    }

    private static native int initLibrary(Object obj, byte[] appName, byte[] appVer, byte[] sdkVer,
                                          long appid, byte[] region, int status,
                                          byte[] logPath, boolean logconsole, boolean useTrans, int abTest);

    private static native int initLibraryLogger(Object obj, byte[] appName, byte[] appVer, byte[] sdkVer,
                                                long appid, byte[] region, int status,
                                                boolean logconsole, boolean useTrans, int abTest);

    private static native boolean initEnd(Object obj);

    private static native int deInitLibrary(Object obj);

    protected static native long increaseId();

    private static native int newChannel(Channel channel, int status);

    private static native int delChannel(Channel channel);

    private static final class NetStatus {
        public static final int NetworkType_NONE = 0;
        public static final int NetworkType_WIFI = 1;
        public static final int NetworkType_4G = 2;
    }

    public static class BroadcastReceiverImpl extends BroadcastReceiver {
        private int mLastNetworkStatus = -100;
        private long mLastNetworkChangedTs = 0;
        private int mNetworkChangedCount = 0;
        private int mNetworkState = -100;

        private Context mAppContext = null;

        public void setAppContext(Context appContext) {
            mAppContext = appContext;
        }

        public int getNetWorkType() {
            if (mLastNetworkStatus == -100) {
                YYServiceCore.log("init to check Network");
                checkNetwork(mAppContext);
            }
            return mLastNetworkStatus;
        }

        public int checkCurrentNetwork() {
            int currentNetworkStatus = mLastNetworkStatus;
            try {
                ConnectivityManager connectivityManager =
                        (ConnectivityManager) mAppContext.getSystemService(Context.CONNECTIVITY_SERVICE);
                if (connectivityManager != null) {
                    NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                    if (activeNetInfo != null && activeNetInfo.getState() != null) {
                        NetworkInfo.State state = activeNetInfo.getState();
                        mNetworkState = state.ordinal();
                        currentNetworkStatus = activeNetInfo.getType();
                        if (currentNetworkStatus != mLastNetworkStatus) {
                            YYServiceCore.log("Network state type changed,previous status:" + mLastNetworkStatus
                                    + ",now status:" + currentNetworkStatus);
                        }
                        return currentNetworkStatus;
                    }
                }
            } catch (Throwable ex) {
                YYServiceCore.log("Network state ex:" + ex.getMessage());
            }
            mNetworkState = -1;
            YYServiceCore.log("Network state is invalidate,last type:" + currentNetworkStatus);
            return currentNetworkStatus;
        }

        public int getNetWorkState() {
            return mNetworkState;
        }

        public long getLastNetworkChangedTs() {
            return mLastNetworkChangedTs;
        }

        public int getNetworkChangedCount() {
            return mNetworkChangedCount;
        }

        private int getNetwork() {
            int status = NetStatus.NetworkType_NONE;
            if (mLastNetworkStatus == ConnectivityManager.TYPE_WIFI) {
                status = (NetStatus.NetworkType_WIFI);
            } else if (mLastNetworkStatus == ConnectivityManager.TYPE_MOBILE) {
                status = (NetStatus.NetworkType_4G);
            }
            return status;
        }

        private void checkNetwork(Context context) {
            try {
                ConnectivityManager connectivityManager =
                        (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                if (connectivityManager != null) {
//NetworkInfo [] networkInfos = connectivityManager.getAllNetworkInfo();
//获取网络的连接情况，断网时会是一个null
                    NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                    if (activeNetInfo != null && (activeNetInfo.getState() != null)) {
                        NetworkInfo.State state = activeNetInfo.getState();
                        mNetworkState = state.ordinal();
                        YYServiceCore.log("Network value is " + activeNetInfo.getType() + ",state=" + state);
                        if (state == NetworkInfo.State.CONNECTED) {
                            if (mLastNetworkStatus == activeNetInfo.getType()) {
                                YYServiceCore.log("Network type not changed:" + mLastNetworkStatus);
                                return;
                            }
                            //判断WIFI网
                            if (activeNetInfo.getType() == ConnectivityManager.TYPE_WIFI) {
                                YYServiceCore.log("Network is TYPE_WIFI");
                                mLastNetworkStatus = ConnectivityManager.TYPE_WIFI;
                                return;
                            } else if (activeNetInfo.getType() == ConnectivityManager.TYPE_MOBILE) {
                                //判断3G网
                                YYServiceCore.log("Network is TYPE_MOBILE");
                                mLastNetworkStatus = ConnectivityManager.TYPE_MOBILE;
                                return;
                            } else {
                                mLastNetworkStatus = activeNetInfo.getType();
                                YYServiceCore.log("Network is :" + mLastNetworkStatus);
                                return;
                            }
                        }
                    }
                }
            } catch (Throwable ex) {
                YYServiceCore.log("Network ex:" + ex.getMessage());
            }
            mNetworkState = -1;
            mLastNetworkStatus = -1;
            YYServiceCore.log("Network is invalidate");
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            YYServiceCore.log("receive Network broadcast");
            checkNotifyNetworkChange();
        }

        private void checkNotifyNetworkChange() {
            int previousStatus = mLastNetworkStatus;
            checkNetwork(mAppContext);
            try {
                if (previousStatus != mLastNetworkStatus) {
                    mNetworkChangedCount++;
                    mLastNetworkChangedTs = System.currentTimeMillis() / 1000;

                    YYServiceCore.log("Network type changed,previous status:" + previousStatus);
                    if (mServiceChannel != null) {
                        if (mLastNetworkStatus == ConnectivityManager.TYPE_WIFI) {
                            mServiceChannel.onNetworkChange(NetStatus.NetworkType_WIFI);
                        } else if (mLastNetworkStatus >= ConnectivityManager.TYPE_MOBILE) {
                            mServiceChannel.onNetworkChange(NetStatus.NetworkType_4G);
                        } else {
                            mServiceChannel.onNetworkChange(NetStatus.NetworkType_NONE);
                        }
                    }
                }
            } catch (Throwable ex) {
                YYServiceCore.log("Network checkNotifyNetworkChange ex:" + ex.getMessage());
            }
        }

        protected void registCallback() {
//            if(Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP/*5.0*/){
            IntentFilter mFilter = new IntentFilter();
            mFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION); // 添加接收网络连接状态改变的Action
            mAppContext.registerReceiver(this, mFilter);
//            }
//            else {
//// 貌似WIFI信号弱，4G信号强时，两个均打开的话，以下监听会频繁调用onLosing，并且关掉WIFI时可能checkNetwork时无效，不能使用
//// 检测到的netType会在WIFI和Mobile间频繁切换，择优选取
//                try {
//                    ConnectivityManager connectivityManager =
//                            (ConnectivityManager) mAppContext.getSystemService(Context.CONNECTIVITY_SERVICE);
//                    YYServiceCore.log( "Network Callback regist OSVersion=" + Build.VERSION.SDK_INT);
//                    if (connectivityManager != null) {
//                        NetworkRequest.Builder builder = new NetworkRequest.Builder();
//
//                        NetworkRequest request = builder.addCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET)
//                                .addTransportType(NetworkCapabilities.TRANSPORT_WIFI)
//                                .addTransportType(NetworkCapabilities.TRANSPORT_CELLULAR)
//                                .build();
//                        ConnectivityManager.NetworkCallback callback = new ConnectivityManager.NetworkCallback() {
//
//                            /**
//                             * 网络可用的回调连接成功
//                             */
//                            @Override
//                            public void onAvailable(Network network) {
//                                super.onAvailable(network);
//                                YYServiceCore.log( "Network Callback onAvailable ==>" + network.toString());
//                                checkNotifyNetworkChange();
//                            }
//
//                            /**
//                             * 实践中在网络连接正常的情况下，丢失数据会有回调
//                             */
//                            @Override
//                            public void onLosing(Network network, int maxMsToLive) {
//                                super.onLosing(network, maxMsToLive);
//                                YYServiceCore.log("Network Callback onLosing ==>"
// + network.toString() + " max==>" + maxMsToLive);
//                            }
//
//                            /**
//                             * 网络不可用时调用和onAvailable成对出现
//                             */
//                            @Override
//                            public void onLost(Network network) {
//                                super.onLost(network);
//                                YYServiceCore.log("Network Callback onLost ==>" + network.toString());
//                                checkNotifyNetworkChange();
//                            }
//
//                            @Override
//                            public void onUnavailable() {
//                                super.onUnavailable();
//                                YYServiceCore.log("Network Callback onUnavailable ==>");
//                            }
//
//                            /**
//                             * 字面直接能理解
//                             *
//                             * @param network             新连接网络
//                             * @param networkCapabilities 新连接网络的一些能力参数
//                             */
//                            @Override
//                            public void onCapabilitiesChanged(Network network,
// NetworkCapabilities networkCapabilities) {
//                                super.onCapabilitiesChanged(network, networkCapabilities);
////                                YYServiceCore.log("Network Callback
/// onCapabilitiesChanged ==>" + networkCapabilities.toString());
////                                回调太多checkNotifyNetworkChange();
//                                //WIFI -> CELLULAR
//                                //[ Transports: CELLULAR Capabilities:
// INTERNET&NOT_RESTRICTED&TRUSTED&NOT_VPN&VALIDATED LinkUpBandwidth>=51200Kbps
// LinkDnBandwidth>=102400Kbps Specifier: <3>]
//                                //CELLULAR -> WIFI
//                                //==>[ Transports: WIFI Capabilities:
// INTERNET&NOT_RESTRICTED&TRUSTED&NOT_VPN&VALIDATED LinkUpBandwidth>=1048576Kbps
// LinkDnBandwidth>=1048576Kbps SignalStrength: -42]
//                            }
//
//                            /**
//                             * 和上面类似，但是没有试出效果
//                             */
//                            @Override
//                            public void onLinkPropertiesChanged(Network network,
// LinkProperties linkProperties) {
//                                super.onLinkPropertiesChanged(network, linkProperties);
//                                //回调太多
////                                YYServiceCore.log( "Network Callback onLinkPropertiesChanged ==>" +
/// linkProperties.toString());
//                            }
//                        };
//
//                        connectivityManager.registerNetworkCallback(request, callback);
//                    }
//                }catch (Throwable e){
//                    YYServiceCore.log("register Network Callback ex:" + e.getMessage());
//                }
//            }
        }
    }
}
