package com.yy.platform.baseservice;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.marshal.ProtoPacket;
import com.yy.platform.baseservice.notify.BroadCastNotify;
import com.yy.platform.baseservice.notify.BroadCastV2Notify;
import com.yy.platform.baseservice.notify.ForceOutNotify;

import com.yy.platform.baseservice.notify.ReportItem;
import com.yy.platform.baseservice.notify.ReportServiceAct;
import com.yy.platform.baseservice.notify.ReportServiceActCount;
import com.yy.platform.baseservice.notify.ReportServiceActRtt;
import com.yy.platform.baseservice.notify.ReportServiceCount;
import com.yy.platform.baseservice.notify.ReportServiceRtt;
import com.yy.platform.baseservice.notify.UnicastNotify;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.statis.StatisReporter;
import com.yy.platform.baseservice.storage.ShareStore;
import com.yy.platform.baseservice.task.AbstractTask;
import com.yy.platform.baseservice.task.BindTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTaskV2;
import com.yy.platform.baseservice.task.RequestDefaultArgs;
import com.yy.platform.baseservice.task.UnBindTask;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;

import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.platform.baseservice.utils.UserGroupTypeString;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Channel implements IChannel {
    private IChannelListener.ITokenProvider mProvider = null;
    private IChannelListener.IChannelStatusNotify mListener = null;
    private IChannelListener.IForceUnBindNotify mAuthNotify = null;

    private List<IChannelListener.IServiceBroadcastNotify> mBroadcastListeners =
            new CopyOnWriteArrayList<IChannelListener.IServiceBroadcastNotify>();
    private List<IChannelListener.IServiceStrGroupBroadcastNotify> mStrGroupBroadcastListeners =
            new CopyOnWriteArrayList<IChannelListener.IServiceStrGroupBroadcastNotify>();

    private List<IChannelListener.IServiceUnicastNotify> mUnicastListeners =
            new CopyOnWriteArrayList<IChannelListener.IServiceUnicastNotify>();

    private Map<Integer, AbstractTask> mRequests = null;

    private Map<IChannelListener.IChannelStatusNotify, Handler> mOtherListener = null;
    private Map<IChannelListener.IServiceBroadcastNotify, Handler> mOtherBroadListener = null;
    private Map<IChannelListener.IServiceStrGroupBroadcastNotify, Handler> mOtherStrBroadListener = null;
    private Map<IChannelListener.IServiceUnicastNotify, Handler> mOtherUniListener = null;
    private int mId = -1;

    private LogProfile.ILog mLogger = null;

    private Handler mMainHandler = null;
    private Long mServerPongTimeDiff = 0L;
    private Long mServerPongTimeStamp = 0L;

    private Long mAlignServerTimeDiff = 0L;
    private boolean mIsAlignment = false;

    private ReportServiceAct mStatisInit = null;

    IChannelListener.IReportPktApi mReportPktApi;

    private boolean mInitSuccess = false;

    public Channel(Handler mainHandler, LogProfile.ILog logger, boolean isInitSuccess) {
        mLogger = logger;
        mInitSuccess = isInitSuccess;

        mMainHandler = mainHandler;
        mListener = null;

        mRequests = new ConcurrentHashMap<>();
        mOtherListener = new ConcurrentHashMap<>();
        mOtherBroadListener = new ConcurrentHashMap<>();
        mOtherStrBroadListener = new ConcurrentHashMap<>();
        mOtherUniListener = new ConcurrentHashMap<>();
    }

    private Channel() {
        mInitSuccess = false;
    }

    public Channel(Handler mainHandler, LogProfile.ILog logger) {
        mLogger = logger;
        mInitSuccess = false;

        mMainHandler = mainHandler;
        mListener = null;

        mRequests = new ConcurrentHashMap<>();
        mOtherListener = new ConcurrentHashMap<>();
        mOtherBroadListener = new ConcurrentHashMap<>();
        mOtherStrBroadListener = new ConcurrentHashMap<>();
        mOtherUniListener = new ConcurrentHashMap<>();
    }

    private boolean checkInit() {
        if (!mInitSuccess) {
            if (mLogger != null) {
                mLogger.outputLog("not inited");
            }
            return false;
        }
        return true;
    }

    protected int startConnect(String testIP, int port,
                               IChannelListener.IChannelStatusNotify listener) {
        if (!checkInit()) {
            return -100;
        }
        mListener = listener;
        if (testIP == null) {
            testIP = "";
        }
        connect(testIP.getBytes(), port);
        return 0;
    }

    protected int stopConnect() {
        if (!checkInit()) {
            return -100;
        }
        return close();
    }

    protected void release() {
        if (!mInitSuccess) {
            return;
        }
        mInitSuccess = false;
    }

    @Override
    public void setDefaultRouteArgs(Map<String, String> routeArgs) {
        if (!checkInit()) {
            return;
        }
        if (routeArgs == null || routeArgs.isEmpty()) {
            return;
        }
        if (mLogger != null) {
            String msg = "default route size:" + routeArgs.size();
            mLogger.outputLog(new String(msg));
        }

        int reqId = (int) YYServiceCore.increaseId();
        RequestDefaultArgs args = new RequestDefaultArgs(reqId, null, null, null,
                RequestDefaultArgs.ArgsSet.ARG1, routeArgs);
        setDefaultArgs(args.marshall());
    }

    @Override
    public void setDefaultHeaders(Map<String, String> headers) {
        if (!checkInit()) {
            return;
        }
        if (headers == null || headers.isEmpty()) {
            return;
        }
        if (mLogger != null) {
            String msg = "default header size:" + headers.size();
            mLogger.outputLog(new String(msg));
        }

        int reqId = (int) YYServiceCore.increaseId();
        RequestDefaultArgs args = new RequestDefaultArgs(reqId, null, null, null,
                RequestDefaultArgs.ArgsSet.ARG2, headers);
        setDefaultArgs(args.marshall());
    }

    @Override
    public int rpcCall(RPCTask.RequestParam requestParam,
                       Bundle options,
                       RPCCallback<RPCTask.ResponseParam> callback) {
        return rpcCall(requestParam, options, mMainHandler, callback);
    }

    @Override
    public int rpcCall(RPCTask.RequestParam requestParam,
                       Bundle options, Handler callbackScheduler,
                       RPCCallback<RPCTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        synchronized (mRequests) {
//        lock(true);
            int reqId = (int) YYServiceCore.increaseId();

            RPCTask request = new RPCTask(reqId, requestParam,
                    callback, options, callbackScheduler == null ? mMainHandler : callbackScheduler);
            mRequests.put(reqId, request);
            int ret = request(request.marshall());
            if (ret == 0) {
//            lock(false);
                //成功
                return reqId;
            }
            //失败
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    public int rpcCall(RPCTask.RequestParam requestParam, Bundle options,
                       Handler callbackScheduler, RPCCallbackWithTrace<RPCTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        synchronized (mRequests) {
//        lock(true);
            int reqId = (int) YYServiceCore.increaseId();
            // requestParam.setTraceId(String.valueOf(reqId));
            RPCTask request = new RPCTask(reqId, requestParam,
                    callback, options, callbackScheduler == null ? mMainHandler : callbackScheduler);
            mRequests.put(reqId, request);
            int ret = request(request.marshall());
            if (ret == 0) {
//            lock(false);
                //成功
                return reqId;
            }
            //失败
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    @Deprecated
    public int bind(long uid, IChannelListener.ITokenProvider tokenProvider,
                    IRPCChannel.RPCCallback<BindTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        StatisReporter.instance().setStatisUid(uid);
        mProvider = tokenProvider;
        byte[] token = tokenProvider.getToken(uid);
        return bind(uid, 0, tokenProvider, callback);
    }

    @Override
    public int bind(long uid, int tokenType, IChannelListener.ITokenProvider tokenProvider,
                    final IRPCChannel.RPCCallback<BindTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }

        StatisReporter.instance().setStatisUid(uid);
        mProvider = tokenProvider;
        byte[] token = tokenProvider.getToken(uid);
        int sdkBind = 0;
        if (0 == uid) {
            sdkBind = ConstCode.SdkResCode.BIND_UID_0;
        } else if (null == token || token.length == 0) {
            sdkBind = ConstCode.SdkResCode.BIND_TOKEN_NIL;
        }
        if (sdkBind < 0) {
            final int sdkBindResCode = sdkBind;
            final int reqId = (int) YYServiceCore.increaseId();
            mMainHandler.post(new Runnable() {
                @Override
                public void run() {
                    callback.onFail(reqId, sdkBindResCode, ConstCode.SdkResCode.UNKNOW,
                            new Exception(ConstCode.SdkResCode.desc(sdkBindResCode)));
                }
            });
            return -1;
        }
        synchronized (mRequests) {
//             lock(true);
            int reqId = (int) YYServiceCore.increaseId();

            BindTask.RequestParam requestParam = new BindTask.RequestParam(uid, token, tokenType);
            requestParam.setSeqId(reqId);

            BindTask loginTask = new BindTask(reqId, requestParam,
                    callback, null, mMainHandler);
            mRequests.put(reqId, loginTask);
            int ret = request(loginTask.marshall());
            if (ret == 0) {
//                 lock(false);
                return reqId;
            }
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    @Deprecated
    public int bind(long uid, byte[] token,
                    final IRPCChannel.RPCCallback<BindTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }

        StatisReporter.instance().setStatisUid(uid);
        int sdkBind = 0;
        if (0 == uid) {
            sdkBind = ConstCode.SdkResCode.BIND_UID_0;
        } else if (null == token || token.length == 0) {
            sdkBind = ConstCode.SdkResCode.BIND_TOKEN_NIL;
        }
        if (sdkBind < 0) {
            final int sdkBindResCode = sdkBind;
            final int reqId = (int) YYServiceCore.increaseId();
            mMainHandler.post(new Runnable() {
                @Override
                public void run() {
                    callback.onFail(reqId, sdkBindResCode, ConstCode.SdkResCode.UNKNOW,
                            new Exception(ConstCode.SdkResCode.desc(sdkBindResCode)));
                }
            });
            return -1;
        }
        synchronized (mRequests) {
//             lock(true);
            int reqId = (int) YYServiceCore.increaseId();

            BindTask.RequestParam requestParam = new BindTask.RequestParam(uid, token, 0);
            requestParam.setSeqId(reqId);

            BindTask loginTask = new BindTask(reqId, requestParam,
                    callback, null, mMainHandler);
            mRequests.put(reqId, loginTask);
            int ret = request(loginTask.marshall());
            if (ret == 0) {
//            lock(false);
                return reqId;
            }
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    public int unBind(IRPCChannel.RPCCallback<UnBindTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        synchronized (mRequests) {
//        lock(true);
            int reqId = (int) YYServiceCore.increaseId();

            UnBindTask logoutTask = new UnBindTask(reqId,
                    new UnBindTask.RequestParam("", 0),
                    callback, null, mMainHandler);
            mRequests.put(reqId, logoutTask);
            int ret = request(logoutTask.marshall());
            if (ret == 0) {
//                 lock(false);
                return reqId;
            }
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    public int subscribeBroadcast(ArrayList<UserGroupType> grps,
                                  IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> callback) {
        return subOrUnSubBroadCast((byte) 1, "", grps, callback);
    }

    @Override
    public int unSubscribeBroadcast(ArrayList<UserGroupType> grps,
                                    IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> callback) {
        return subOrUnSubBroadCast((byte) 0, "", grps, callback);
    }

    private int subOrUnSubBroadCast(byte opType, String ctx, ArrayList<UserGroupType> grps,
                                    IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        synchronized (mRequests) {
//             lock(true);
            int reqId = (int) YYServiceCore.increaseId();
            BroadSubOrUnSubTask loginTask = new BroadSubOrUnSubTask(reqId,
                    new BroadSubOrUnSubTask.RequestParam(ctx, grps, opType),
                    callback, null, mMainHandler);
            mRequests.put(reqId, loginTask);
            int ret = request(loginTask.marshall());
            if (ret == 0) {
//            lock(false);
                return reqId;
            }
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    public int subscribeStrBroadcast(Set<UserGroupTypeString> grps,
                                     IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> callback) {
        return subOrUnSubStrBroadCast((byte) 1, "", grps, callback);
    }

    @Override
    public int unSubscribeStrBroadcast(Set<UserGroupTypeString> grps,
                                       IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> callback) {
        return subOrUnSubStrBroadCast((byte) 0, "", grps, callback);
    }

    private int subOrUnSubStrBroadCast(byte opType, String ctx, Set<UserGroupTypeString> grps,
                                       IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> callback) {
        if (!checkInit()) {
            return -100;
        }
        synchronized (mRequests) {
//             lock(true);
            int reqId = (int) YYServiceCore.increaseId();
            BroadSubOrUnSubTaskV2 loginTask = new BroadSubOrUnSubTaskV2(reqId,
                    new BroadSubOrUnSubTaskV2.RequestParam(ctx, grps, opType),
                    callback, null, mMainHandler);
            mRequests.put(reqId, loginTask);
            int ret = request(loginTask.marshall());
            if (ret == 0) {
//            lock(false);
                return reqId;
            }
            mRequests.remove(reqId);
        }
//        lock(false);
        return -1;
    }

    @Override
    public long getServerTimeStampDiff() {
        synchronized (mServerPongTimeDiff) {
            return mServerPongTimeDiff;
        }
    }

    @Override
    public long getLastSyncServerTS() {
        synchronized (mServerPongTimeStamp) {
            return mServerPongTimeStamp;
        }
    }

    @Override
    public long getAlignmentServerTS() {
        synchronized (mAlignServerTimeDiff) {
            if (!mIsAlignment) {
                return 0;
            }
            long syncTS = System.currentTimeMillis() + mAlignServerTimeDiff;

            return syncTS;
        }
    }

    @Override
    @Deprecated
    public void setTokenProvider(IChannelListener.ITokenProvider tokenProvider) {
        mProvider = tokenProvider;
    }

    @Override
    public void setForceUnBindListener(IChannelListener.IForceUnBindNotify listener) {
        mAuthNotify = listener;
    }

    @Override
    public void registUnicastListener(IChannelListener.IServiceUnicastNotify listener) {
        mUnicastListeners.add(listener);
        if (mLogger != null) {
            String msg = "regist unicastlistener size:" + mUnicastListeners.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void unregistUnicastListener(IChannelListener.IServiceUnicastNotify listener) {
        mUnicastListeners.remove(listener);
        mOtherUniListener.remove(listener);
        if (mLogger != null) {
            String msg = "unregist unicastlistener size:" + mUnicastListeners.size() +
                    ",other size:" + mOtherUniListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceBroadcastNotify listener) {
        mBroadcastListeners.add(listener);
        if (mLogger != null) {
            String msg = "regist broadcastlistener size:" + mBroadcastListeners.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void unregistBroadcastListener(IChannelListener.IServiceBroadcastNotify listener) {
        mBroadcastListeners.remove(listener);
        mOtherBroadListener.remove(listener);
        if (mLogger != null) {
            String msg = "unregist broadcastlistener size:" + mBroadcastListeners.size() +
                    ",other size:" + mOtherBroadListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify listener) {
        mStrGroupBroadcastListeners.add(listener);
        if (mLogger != null) {
            String msg = "regist str broadcastlistener size:" + mStrGroupBroadcastListeners.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void unregistBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify listener) {
        mStrGroupBroadcastListeners.remove(listener);
        mOtherStrBroadListener.remove(listener);
        if (mLogger != null) {
            String msg = "unregist str broadcastlistener size:" + mStrGroupBroadcastListeners.size() +
                    ",other size:" + mOtherStrBroadListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registUnicastListener(IChannelListener.IServiceUnicastNotify listener,
                                      Handler listenerThread) {
        if (listenerThread == null) {
            listenerThread = mMainHandler;
        }
        mOtherUniListener.put(listener, listenerThread);
        if (mLogger != null) {
            String msg = "regist other unicastlistener size:" + mOtherUniListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceBroadcastNotify listener,
                                        Handler listenerThread) {
        if (listenerThread == null) {
            listenerThread = mMainHandler;
        }
        mOtherBroadListener.put(listener, listenerThread);
        if (mLogger != null) {
            String msg = "regist other broadcastlistener size:" + mOtherBroadListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify listener,
                                        Handler listenerThread) {
        if (listenerThread == null) {
            listenerThread = mMainHandler;
        }
        mOtherStrBroadListener.put(listener, listenerThread);
        if (mLogger != null) {
            String msg = "regist other str broadcastlistener size:" + mOtherStrBroadListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void registChannelStatusListener(IChannelListener.IChannelStatusNotify listener,
                                            Handler listenerThread) {
        if (listenerThread == null) {
            listenerThread = mMainHandler;
        }
        mOtherListener.put(listener, listenerThread);
        if (mLogger != null) {
            String msg = "regist more status listener size:" + mOtherListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public void unregistChannelStatusListener(IChannelListener.IChannelStatusNotify listener) {
        mOtherListener.remove(listener);
        if (mLogger != null) {
            String msg = "unregist more status listener size:" + mOtherListener.size();
            mLogger.outputLog(new String(msg));
        }
    }

    @Override
    public int getInstId() {
        if (!checkInit()) {
            return -100;
        }
        return instId();
    }

    protected void onNetworkChange(int status) {
        if (!checkInit()) {
            return;
        }
        networkChange(status);
    }

    private native int instId();

    private native int connect(byte[] testIP, int port);

    private native int close();

    private native int setDefaultArgs(byte[] args);

    private native int request(byte[] req);

    private native int networkChange(int status);

    private native int getNetOptimize();

    private void onChannelStatus(final int status) {
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                if (mListener == null) {
                    return;
                }
                synchronized (mListener) {
                    mListener.onStatus(status);
                }
            }
        });
        synchronized (mOtherListener) {
            for (final Map.Entry<IChannelListener.IChannelStatusNotify, Handler> lis : mOtherListener.entrySet()) {
                lis.getValue().post(new Runnable() {
                    @Override
                    public void run() {
                        lis.getKey().onStatus(status);
                    }
                });
            }
        }
    }

    private void onSyncServerTime(long timestamp) {
        long timeDiff = timestamp - System.currentTimeMillis();
        synchronized (mServerPongTimeStamp) {
            mServerPongTimeStamp = timestamp;
        }
        synchronized (mServerPongTimeDiff) {
            mServerPongTimeDiff = timeDiff;
        }
    }

    private void onSyncAlignedTimeDiff(long timestampDiff) {
        synchronized (mAlignServerTimeDiff) {
            mIsAlignment = true;
            mAlignServerTimeDiff = timestampDiff;
        }
    }

    private byte[] requestToken(long uid) {
        if (mProvider == null) {
            return "".getBytes();
        }

        synchronized (mProvider) {
            byte[] token = mProvider.getToken(uid);
            if (token == null) {
                return "".getBytes();
            }
            return token;
        }
    }

    private void onResponseSuccess(int reqId, int sdkResCode, byte[] data) {
        synchronized (mRequests) {
            ProtoPacket req = mRequests.remove(reqId);

            if (req != null) {
                AbstractTask reqAbstract = (AbstractTask) req;
                reqAbstract.unmarshall(data);
                reqAbstract.onResponseSuccess(reqId, sdkResCode);
            }
        }
    }

    private void onResponseFail(int reqId, int sdkResCode, byte[] data) {
        synchronized (mRequests) {
            ProtoPacket req = mRequests.remove(reqId);

            if (req != null) {
                AbstractTask reqAbstract = (AbstractTask) req;
                reqAbstract.unmarshall(data);
                reqAbstract.onResponseFail(reqId, sdkResCode);
            }
        }
    }

    private void onForceOutNotify(long realUri, byte[] resData) {
        final ForceOutNotify notify = new ForceOutNotify();
        notify.unmarshall(resData);
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                if (mAuthNotify == null) {
                    return;
                }
                synchronized (mAuthNotify) {
                    if (mAuthNotify != null) {
                        mAuthNotify.onForceOut(notify.mUid, notify.mCode, notify.mDesc);
                    }
                }
            }
        });
    }

    private void onUnicastNotify(long realUri, byte[] resData) {
        final UnicastNotify notify = new UnicastNotify();
        notify.unmarshall(resData);
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (mUnicastListeners) {
                    for (IChannelListener.IServiceUnicastNotify listener : mUnicastListeners) {
                        listener.onUnicast(notify.mUid, notify.mServiceName,
                                notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                }
            }
        });
        synchronized (mOtherUniListener) {
            for (final Map.Entry<IChannelListener.IServiceUnicastNotify, Handler> lis : mOtherUniListener.entrySet()) {
                lis.getValue().post(new Runnable() {
                    @Override
                    public void run() {
                        lis.getKey().onUnicast(notify.mUid, notify.mServiceName,
                                notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                });
            }
        }
    }

    private void onBroadCastNotify(long realUri, byte[] resData) {
        final BroadCastNotify notify = new BroadCastNotify();
        notify.unmarshall(resData);
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (mBroadcastListeners) {
                    for (IChannelListener.IServiceBroadcastNotify listener : mBroadcastListeners) {
                        listener.onBroadCast(notify.mUid, notify.mUserGrpType, notify.mUserGrpId,
                                notify.mServiceName, notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                }
            }
        });
        synchronized (mOtherBroadListener) {
            for (final Map.Entry<IChannelListener.IServiceBroadcastNotify, Handler> lis
                    : mOtherBroadListener.entrySet()) {
                lis.getValue().post(new Runnable() {
                    @Override
                    public void run() {
                        lis.getKey().onBroadCast(notify.mUid, notify.mUserGrpType, notify.mUserGrpId,
                                notify.mServiceName, notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                });
            }
        }
    }

    private void onBroadCastV2Notify(long realUri, byte[] resData) {
        final BroadCastV2Notify notify = new BroadCastV2Notify();
        notify.unmarshall(resData);
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (mBroadcastListeners) {
                    for (IChannelListener.IServiceStrGroupBroadcastNotify listener : mStrGroupBroadcastListeners) {
                        listener.onBroadCastFromStrGroup(notify.mUid, notify.mUserGroup,
                                notify.mServiceName, notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                }
            }
        });
        synchronized (mOtherStrBroadListener) {
            for (final Map.Entry<IChannelListener.IServiceStrGroupBroadcastNotify, Handler> lis
                    : mOtherStrBroadListener.entrySet()) {
                lis.getValue().post(new Runnable() {
                    @Override
                    public void run() {
                        lis.getKey().onBroadCastFromStrGroup(notify.mUid, notify.mUserGroup,
                                notify.mServiceName, notify.mFunctionName, notify.mProtoType, notify.mData);
                    }
                });
            }
        }
    }

    @Override
    public void setHiidoMetricsApi(String hdid, IChannelListener.IServiceHiidoMetricsStatisApi listener) {
        if (listener != null) {
            StatisReporter.instance().setMetricsHiidoApi(listener);
            ShareStore.INSTANCE.setHdId(hdid);
        }
    }

    protected void initReport(final long appId, final String appName, final String appVer,
                              final String sdkVer) {

        mStatisInit = new ReportServiceAct();
        mStatisInit.mAct = "ystinit";
        mStatisInit.mKeyFields = new ReportItem.ServiceActKeyItem[1];
        ReportItem.ServiceActKeyItem keyItem = new ReportItem.ServiceActKeyItem();
        keyItem.mLongFields = new HashMap<>();

        keyItem.mIntFields = new HashMap<String, Integer>();
        keyItem.mIntFields.put("said", (int) appId);
        keyItem.mStringFields = new HashMap<>();
        keyItem.mStringFields.put("appn", appName);
        keyItem.mStringFields.put("appv", appVer);
        keyItem.mStringFields.put("sdkv", sdkVer);
        keyItem.mStringFields.put("osver", "And-" + Build.VERSION.RELEASE);
        keyItem.mStringFields.put("model", Build.MODEL);
        keyItem.mStringFields.put("lang",
                Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry());

        mStatisInit.mKeyFields[0] = keyItem;

        //等待5s可能可以取到uid
        mMainHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                mStatisInit.mKeyFields[0].mLongFields.put("uid", StatisReporter.instance().getStaticUid());
                if (YYServiceCore.getInstance() != null) {
                    StatisReporter.instance().onServiceAct(mStatisInit);
                }
            }
        }, 10000);
    }

    private void onReport(long uri, byte[] data) {
        if (uri == ReportServiceAct.URI) {
            ReportServiceAct reportItem = new ReportServiceAct();
            reportItem.unmarshall(data);
            StatisReporter.instance().onServiceAct(reportItem);
        } else if (uri == ReportServiceRtt.URI) {
            ReportServiceRtt reportItem = new ReportServiceRtt();
            reportItem.unmarshall(data);
            StatisReporter.instance().onServiceRtt(reportItem);
        } else if (uri == ReportServiceCount.URI) {
            ReportServiceCount reportItem = new ReportServiceCount();
            reportItem.unmarshall(data);
            StatisReporter.instance().onServiceCount(reportItem);
        } else if (uri == ReportServiceActRtt.URI) {
            ReportServiceActRtt reportItem = new ReportServiceActRtt();
            reportItem.unmarshall(data);
            StatisReporter.instance().onServiceActRtt(reportItem);
        } else if (uri == ReportServiceActCount.URI) {
            ReportServiceActCount reportItem = new ReportServiceActCount();
            reportItem.unmarshall(data);
            StatisReporter.instance().onServiceAct(reportItem.mAct);
            StatisReporter.instance().onServiceCount(reportItem.mCount);
        }
    }

    @Override
    public void setReportPktApi(IChannelListener.IReportPktApi listener) {
        if (listener != null) {
            mReportPktApi = listener;
        }
    }

    private void onReportPktErr(final int code, final byte[] pkt, final byte[] uri) {
        String logmsg = "error pkt,code:" + code + ",pkt len:" + pkt.length;
        YYServiceCore.log(logmsg);
        if (mReportPktApi == null) {
            return;
        }
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                mReportPktApi.reportPktError(code, new String(pkt), new String(uri));
            }
        });
    }

    @Override
    public int getNetOptimizeSwitch() {
        if (!checkInit()) {
            return -100;
        }
        return getNetOptimize();
    }
}
