﻿#ifndef _WATCH_HELPER_H_FXW_
#define _WATCH_HELPER_H_FXW_

#include "commondefine.h"

NAMESPACE_BASEMOD_BEGIN
template <class W,int WS = 5 > class WatchHelper
{
public:
	typedef W watcher_t;
	WatchHelper(){
		for(int i = 0; i < WS; ++i)
		{
			watchers[i] = NULL;
		}
		realSize = 0;
	}

	virtual void watch(watcher_t *w)
	{
		if(!findInArray(w))
		{
			watchers[realSize] = w;
			realSize ++;
//			for(int i = 0; i < realSize; ++i)
//			{
//				if(watchers[i] == NULL)
//				{
//					watchers[i] = w;
//					return;
//				}
//			}
		}
	}

	virtual void revoke(watcher_t *w)
	{
		for(int i = 0; i < realSize; ++i)
		{
			if(watchers[i] == w){
				watchers[i] = NULL;
			}
		}
	}

	void clearWatcher()
	{
		for(int i = 0; i < realSize; ++i){
			watchers[i] = NULL;
		}
	}
	void forEachWatcher0(void (W::*fun)()){
		for(int i = 0; i < realSize; ++i){
			if(watchers[i] != NULL)
				(watchers[i]->*fun)();
		}
	}
	template<typename U> void forEachWatcher1(void (W::*fun)(U), U param){
		for(int i = 0; i < realSize; ++i){
			if(watchers[i] != NULL)
				(watchers[i]->*fun)(param);
		}
	}

protected:
	watcher_t* watchers[WS];
	int realSize;
private:
	bool findInArray(watcher_t *w){
		for(int i = 0; i < realSize; ++i){
			if(watchers[i] == w)
				return true;
		}
		return false;
	}
};
NAMESPACE_BASEMOD_END
#endif
