﻿#pragma once

#include "commondefine.h"
#include "unistr.h"
#include "int_types.h"

namespace protocol
{
	typedef		UniString		DATE ;			//	MM-DD-YYYY

	typedef		UniString		DATETIME ;		//	like "Tue May 03 21:51:03 1994"

	typedef		uint32_t		COLOR ;			//	0x00bbggrr

	enum	FONTEFFECTS{
		FE_BOLD = 1 ,
		FE_ITALIC = 2 ,
		FE_STRIKETHROUGH = 4 ,
		FE_UNDERLINE = 8
	};
    struct  ImFont {
        uint32_t		effects ;
        std::wstring	name ;
        ImFont(){		// default ?
            effects = 0 ;
#ifdef WIN32
            name = L"Arial" ;
#endif
        };
        ImFont(const ImFont & src ){
            effects = src.effects ;
            name = src.name ;
        }
        ImFont & operator = (const ImFont & src ){
            if( this != & src ){
                effects = src.effects ;
                name = src.name ;
            }
            return * this ;
        }
    };
	struct	FONT{
		uint32_t		effects ;
#ifdef __IM__
        std::wstring		name ;
#else
        UniString		name ;
#endif // __IM__
		FONT(){		// default ?
			effects = 0 ;
#ifdef WIN32
			name = L"Arial" ;
#endif
		};
		FONT(const FONT & src ){
			effects = src.effects ;
			name = src.name ;
		}
		FONT & operator = (const FONT & src ){
			if( this != & src ){
				effects = src.effects ;
				name = src.name ;
			}
			return * this ;
		}
	};
}
