﻿//
// Created by HUTAO on 2017/6/27.
//

#ifndef YYLIVESDK_PARENT_BLOCKBUFFER_EX_H
#define YYLIVESDK_PARENT_BLOCKBUFFER_EX_H

#include "commondefine.h"
#include "blockbuffer.h"
#ifdef _WIN32
#pragma warning (disable: 4100) 
#endif
#ifndef INCR_CAP_2STAGE
#define INCR_CAP_2STAGE
#endif

#ifndef LIKELY
#ifdef __GNUC__
#define LIKELY(x)       __builtin_expect((x),1)
#define UNLIKELY(x)     __builtin_expect((x),0)
#else
#define LIKELY
	#define UNLIKELY
#endif
#endif

#if defined(__i386__)||defined(WIN32)||defined(__x86_64__)
	#define PACKX_BUF_WRITER(ptr, type, val) *((type*)ptr) = (val)
	#define PACKX_BUF_READER(ptr, type, val) val = (*((type*)ptr));
#else
	//For platforms which have strict-align
	#define PACKX_BUF_WRITER(ptr, type, val) {type v_ = val; memmove(ptr, &v_, sizeof(type));}
	#define PACKX_BUF_READER(ptr, type, val) {memmove(&val, ptr, sizeof(type));}
#endif

NAMESPACE_BASEMOD_BEGIN
	template <typename BlockAllocator = def_block_alloc_4k, unsigned MaxBlocks = 2>
	class BlockBufferX
	{
	public:
		typedef BlockBuffer<BlockAllocator, MaxBlocks> SoxBlockBuffer;
		typedef BlockAllocator allocator;
		enum { max_blocks = MaxBlocks };
		enum { npos = size_t(-1) };
		
		BlockBufferX(SoxBlockBuffer* objBB) : m_data(objBB->m_data),
											  m_size(objBB->m_size), m_block(objBB->m_block)
		{ //m_block = 0; m_size = 0; m_data = NULL;
//			m_capacity = capacity();
			//m_free = 0;
		}
		
		bool   empty() const	 { return size() == 0; }
		size_t block() const	 { return m_block; }
		size_t blocksize() const { return allocator::requested_size; }
		size_t capacity() const  { return m_block * allocator::requested_size; }
		size_t maxsize() const	 { return max_blocks * allocator::requested_size; }
		size_t maxfree() const	 { return maxsize() - size(); }
		size_t freespace() const { return capacity() - size(); }
		
		char * data() const 	 { return m_data; }
		size_t size() const 	 { return m_size; }
		
		bool resize(size_t n, char c=0);
		bool reserve(size_t n);
		bool append(const char * app, size_t len);
		
		template <typename PrimType>
		bool append_prim(PrimType n);
		
		char * pre_batch_append(size_t n);
		
		void post_batch_append(size_t n);
		
		bool replace(size_t pos, const char * rep, size_t n);
		
		template <typename PrimType>
		bool replace_prim(size_t pos, PrimType n);
		
		void erase(size_t pos=0, size_t n=npos, bool hold=false);
		
		static size_t current_total_blocks() { return SoxBlockBuffer::s_current_total_blocks; }
		static size_t peak_total_blocks()    { return SoxBlockBuffer::s_peak_total_blocks; }
	
	protected:
		bool increase_capacity(size_t increase_size);
#ifdef INCR_CAP_2STAGE
		bool increase_capacity_real(size_t increase_size, size_t free);
#endif
		char * tail()          { return m_data + m_size; }
		void size(size_t size) { assert(size <= capacity()); m_size = size;
			//m_free = freespace();
		}
	
	private:
		void free();
		
		//SoxBlockBuffer& m_bb;
		
		char *& m_data;
		size_t& m_size;
		//__m64 m_size;
		size_t& m_block;
		
//		size_t m_capacity;
		//__m64 m_capacity;
		
		BlockBufferX(const BlockBufferX&);
		void operator = (const BlockBufferX &);
		
	};
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline void BlockBufferX<BlockAllocator, MaxBlocks >::free()
	{
		if (m_block > 0)
		{
			allocator::ordered_free(m_data, m_block);
			SoxBlockBuffer::s_current_total_blocks -= m_block;
			m_data = NULL;
			m_size = 0;
			m_block = 0;
//			m_capacity = 0;
			//m_free = freespace();
		}
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::append(const char * app, size_t len)
	{
		if (UNLIKELY(len == 0))
			return true; // no data
		
		if (increase_capacity(len))
		{
			memmove(tail(), app, len); // append
			m_size += len;
			//m_free -= len;
			return true;
		}
		return false;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks> template <typename PrimType>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks>::append_prim( PrimType n )
	{
		if (increase_capacity(sizeof(PrimType)))
		{
			//*((PrimType*)tail()) = n;
			PACKX_BUF_WRITER(tail(), PrimType, n);
			m_size += sizeof(PrimType);
			//m_free -= sizeof(PrimType);
			return true;
		}
		return false;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks> template <typename PrimType>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::replace_prim(size_t pos, PrimType d)
	{
		if (pos >= size()) // out_of_range ?
			return append_prim(d);
		
		if (pos + sizeof(PrimType) >= size()) // replace all beginning with position pos
		{
			m_size = pos;
			//m_free = freespace();
			return append_prim(d);
		}
		if (sizeof(PrimType) > 0)
			//*((PrimType*)(m_data + pos)) = d;
		PACKX_BUF_WRITER((m_data + pos), PrimType, d);
		return true;
	}
	
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	char * BlockBufferX<BlockAllocator, MaxBlocks>::pre_batch_append( size_t n )
	{
		if (increase_capacity(n))
		{
			return tail();
		}
		return NULL;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	void BlockBufferX<BlockAllocator, MaxBlocks>::post_batch_append( size_t n)
	{
		m_size += n;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::reserve(size_t n)
	{
		return (n <= capacity() || increase_capacity(n - capacity()));
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::resize(size_t n, char c)
	{
		if (n > size()) // increase
		{
			size_t len = n - size();
			if (UNLIKELY(!increase_capacity(len)))
				return false;
			//正常情况下应该没用，先去掉，有问题再说
			//if (len)
			//	memset(tail(), c, len);
		}
		m_size = n;
		//m_free = freespace();
		return true;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::replace(size_t pos, const char * rep, size_t n)
	{
		if (pos >= size()) // out_of_range ?
			return append(rep, n);
		
		if (pos + n >= size()) // replace all beginning with position pos
		{
			m_size = pos;
			//m_free = freespace();
			return append(rep, n);
		}
		if (n > 0)
			memmove(m_data + pos, rep, n);
		return true;
	}
	
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline void BlockBufferX<BlockAllocator, MaxBlocks >::erase(size_t pos, size_t n, bool hold)
	{
		assert(pos <= size()); // out_of_range debug.
		
		size_t m = size() - pos; // can erase
		if (n >= m)
			m_size = pos; // all clear after pos
		else
		{
			m_size -= n;
			memmove(m_data + pos, m_data + pos + n, m - n);
		}
		//m_free = freespace();
		
		if (empty() && !hold)
			free();
	}
	
	/*
 	* after success increase_capacity : freespace() >= increase_size
 	* if false : does not affect exist data
 	*/
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::increase_capacity(size_t increase_size)
	{
		//if (UNLIKELY(increase_size == 0)) return true;
		
		//去掉m_capacity，若是VSMarshallable协议包并且包含Marshallable成员，
		//由于对Marshallable成员的序列化执行的是BlockBuffer中的方法，并不会更新到本BlockBufferX的m_capacity,
		//继续下一个成员marshal时若一个block不够而执行到本方法就会出现m_capacity - m_size < 0的情况，造成溢出
		size_t free = freespace();
//		size_t free = m_capacity - m_size;
		//*((char *)(0)) = 1; //test
		//if (increase_size > maxsize() - free) throw std::out_of_range("BlockBuffer out of range");
		if (LIKELY(free >= increase_size)) return true;

#ifdef INCR_CAP_2STAGE
		return increase_capacity_real(increase_size, free);
#else
		//or just force inline increase_capacity_real()...
		
		size_t newblock = m_block;
		
		increase_size -= free;
		newblock += increase_size / allocator::requested_size;
		if ((increase_size % allocator::requested_size) > 0)
			newblock ++;
		
		if (newblock > max_blocks) return false;
		char * newdata = (char*)(allocator::ordered_malloc(newblock));
		if (0 == newdata) return false;
		
		if (m_block > 0)
		{	// copy old data and free old block
			memcpy(newdata, m_data, m_size);
			allocator::ordered_free(m_data, m_block);
		}
		
		s_current_total_blocks += newblock - m_block;
		if (s_current_total_blocks > s_peak_total_blocks)
			s_peak_total_blocks = s_current_total_blocks;
		
		m_data = newdata;
		m_block = newblock;
		//m_free = freespace();
//		m_capacity = capacity();
		return true;
#endif
	}

#ifdef INCR_CAP_2STAGE
	template <typename BlockAllocator, unsigned MaxBlocks>
	inline bool BlockBufferX<BlockAllocator, MaxBlocks >::increase_capacity_real(size_t increase_size, size_t free)
	{
		size_t newblock = m_block;
		
		//size_t free = m_capacity - m_size;
		
		increase_size -= free;
		newblock += increase_size / allocator::requested_size;
		if ((increase_size % allocator::requested_size) > 0)
			newblock ++;
		
		if (newblock > max_blocks) return false;
		char * newdata = (char*)(allocator::ordered_malloc(newblock));
		if (0 == newdata) return false;
		
		if (m_block > 0)
		{	// copy old data and free old block
			memcpy(newdata, m_data, m_size);
			allocator::ordered_free(m_data, m_block);
		}
		
		SoxBlockBuffer::s_current_total_blocks += newblock - m_block;
		if (SoxBlockBuffer::s_current_total_blocks > SoxBlockBuffer::s_peak_total_blocks)
			SoxBlockBuffer::s_peak_total_blocks = SoxBlockBuffer::s_current_total_blocks;
		
		m_data = newdata;
		m_block = newblock;
		//m_free = freespace();
//		m_capacity = capacity();
		return true;
	}
#endif
NAMESPACE_BASEMOD_END
#endif //YYLIVESDK_PARENT_BLOCKBUFFER_EX_H
