﻿//
// Created by HUTAO on 2017/6/28.
//

#ifndef YYPROTO_PROTOPACKET_H
#define YYPROTO_PROTOPACKET_H

#include "commondefine.h"
#include "IProtoPacket.h"

NAMESPACE_BASEMOD_BEGIN
	class ProtoPacket : public IProtoPacket
	{
	public:
		enum MemType
		{
			MEM_POOL,
			MEM_NEW
		};

		ProtoPacket(char* buf, int len);
		ProtoPacket(char* buf, int len, int uri);
		ProtoPacket(char* buf, int len, int uri, int connId);
		ProtoPacket(char* buf, int len, int uri, int connId, int res);
		virtual ~ProtoPacket();
	
	public:
		virtual int			getConnId();
		virtual uint32_t	getUri() ;
		virtual int			getLength();
		virtual int			getRes();
		virtual char*		getData();
		virtual bool		unpack(Marshallable& obj);
		virtual IProtoPacket*	clone();
		virtual bool getIsValid();
	
	public:
		void	marshal(int uri, const Marshallable& req);
		void	unmarshal(const char *data, int len);
		void	setMemType(MemType type);
		MemType	getMemType();
		void	setConnId(int connId);
		void    setUri(int uri);
		void	reset();

		void 	setDataLen(int len);
		void 	setRes(int res);
		void    setIsValid(bool isValid);
	
	private:
		int		_connId;
		char*	_buf;
		int		_len;
		int		_uri;
		int		_res;
		MemType	_mem_type;
		bool _isValid;
	};
NAMESPACE_BASEMOD_END
#endif //YYPROTO_PROTOPACKET_H
