﻿//
// Created by HUTAO on 2018/5/22.
//

#ifndef YYBASENETSDK_PARENT_ASYNCTASK_H
#define YYBASENETSDK_PARENT_ASYNCTASK_H
#include <functional>
#include "commondefine.h"
#include "ITaskTimer.h"

NAMESPACE_BASEMOD_BEGIN
	typedef std::function<void()> AsyncFunc;

	class AsyncTask : public IProtoTask
	{
	public:
		AsyncTask(AsyncFunc&& f)
				:func(f)
		{
			m_priority = HIGH_PRIORITY;
		}

		virtual ~AsyncTask()
		{}

		virtual void run()
		{
			func();
		}
		virtual void setRepeat(bool repeat) {m_bRepeat = false;};
		virtual bool getRepeat() { return false;}

		void start(ITaskThread *thread){
			thread->post(this);
		}
		void start(ITaskThread *thread,uint32_t delay)
		{
			thread->post(this,delay);
		};
		void cancel()
		{

		};
	private:
		AsyncFunc func;
	};

	void AsyncRun(ITaskThread* thread,AsyncFunc&& f);
	void AsyncExit(ITaskThread* thread,AsyncFunc&& f);

	class ExitTask : public IProtoTask
	{
	public:
		ExitTask(AsyncFunc&& f)
				:func(f)
		{
			m_priority = EXIT_PRIORITY;
		}
		virtual ~ExitTask()
		{}
		virtual void run()
		{
			func();
		}
		virtual void setRepeat(bool repeat) {m_bRepeat = false;};
		virtual bool getRepeat() { return false;}
	private:
		AsyncFunc func;
	};

NAMESPACE_BASEMOD_END

#endif //YYBASENETSDK_PARENT_ASYNCTASK_H
