package com.yy.platform.baseservice.utils;

import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;

public class UserGroupType extends ProtoPacket {

    public long mGroupType;
    public long mGroupId;

    /**
     * 广播组
     * @param grpType
     *          广播组Type
     * @param grpId
     *          广播组Id
     */
    public UserGroupType(long grpType,long grpId){
        mGroupType = grpType;
        mGroupId = grpId;
    }

    @Override
    public int hashCode()
    {
        return (int)mGroupType;
    }
    @Override
    public boolean equals(Object obj)
    {
        if(!(obj instanceof UserGroupType))
            return false;

        UserGroupType p= (UserGroupType)obj;
        return this.mGroupType == p.mGroupType
                && (this.mGroupId == p.mGroupId);
    }
    @Override
    public void marshall(ByteBuffer byteBuffer){
        super.marshall(byteBuffer);
        this.pushInt64(mGroupType);
        this.pushInt64(mGroupId);
    }
}
