package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;

public class UnBindTask extends AbstractTask<UnBindTask.ResponseParam> {

    private RequestParam mSrvReq;

    public static final long URI = 12;

    public UnBindTask(int reqId, RequestParam requestParam,
                      IRPCChannel.RPCCallback<ResponseParam> callback,
                      Bundle options, Handler scheduler) {
        super(URI, reqId, callback, options, scheduler);

        mSrvReq = requestParam;
    }

    @Override
    public byte[] marshall() {
        pushMarshallable(mSrvReq);
        return super.marshall();
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
        mSrvRes = (ResponseParam) popMarshallable(ResponseParam.class);
    }

    public static class RequestParam extends ProtoPacket {
        private String mContext;
        private long mUid;

        public RequestParam(String ctx, long uid) {
            mContext = ctx == null ? "" : ctx;
            mUid = uid;
        }

        @Override
        public void marshall(ByteBuffer byteBuffer) {
            super.marshall(byteBuffer);
            this.pushBytes(mContext.getBytes());
            this.pushInt64(mUid);
        }

    }

    public static class ResponseParam extends ProtoPacket {
        public String mContext;
        public int mResCode;
        public String mResMsg;

        @Override
        public void unmarshall(ByteBuffer byteBuffer) {
            super.unmarshall(byteBuffer);
            mContext = this.popString16("UTF-8");
            mResCode = this.popInt();
            mResMsg = this.popString16("UTF-8");
        }
    }

    @Override
    public void onResponseSuccess(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onSuccess(requestId, mSrvRes);
            }
        });
    }

    @Override
    public void onResponseFail(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onFail(requestId, sdkResCode, mSrvRes.mResCode,
                        new Exception(mSrvRes.mResMsg));
            }
        });
    }
}
