package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;
import java.util.Map;

public class RequestDefaultArgs extends AbstractTask<RequestDefaultArgs.ResponseParam> {

    private RequestDefaultArgs.RequestParam mSrvReq;

    public static final long URI = 1;

    public static final class ArgsSet {
        public static final int ARG1 = 1;
        public static final int ARG2 = 2;
        public static final int ARG3 = 4;
    }

    public RequestDefaultArgs(int reqId, IRPCChannel.RPCCallback<ResponseParam> callback,
                              Bundle options, Handler scheduler,
                              int setArgs, Map<String, String> args) {
        super(URI, reqId, callback, options, scheduler);
        mSrvReq = new RequestParam(setArgs);
        if (setArgs == ArgsSet.ARG1) {
            mSrvReq.mDefaultRoutes = args;
        } else if (setArgs == ArgsSet.ARG2) {
            mSrvReq.mDefaultHeaders = args;
        }
    }

    @Override
    public byte[] marshall() {
        pushMarshallable(mSrvReq);
        return super.marshall();
    }

    protected static class RequestParam extends ProtoPacket {
        private int mSetArgs;
        //ARG1
        private Map<String, String> mDefaultRoutes;
        //ARG2
        private Map<String, String> mDefaultHeaders;

        protected RequestParam(int setArgs) {
            mSetArgs = setArgs;
        }

        @Override
        public void marshall(ByteBuffer byteBuffer) {
            super.marshall(byteBuffer);
            this.pushInt(mSetArgs);
            this.pushMap(mDefaultRoutes, String.class);
            this.pushMap(mDefaultHeaders, String.class);
        }
    }

    protected static class ResponseParam extends ProtoPacket {

        public ResponseParam() {
        }

        @Override
        public void unmarshall(ByteBuffer buf) {
            super.unmarshall(buf);

        }
    }

    @Override
    public void onResponseSuccess(final int requestId, final int sdkResCode) {

    }

    @Override
    public void onResponseFail(final int requestId, final int sdkResCode) {
    }
}
