package com.yy.platform.baseservice.statis;

import android.os.Handler;
import android.os.HandlerThread;

import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.notify.ReportItem;
import com.yy.platform.baseservice.notify.ReportServiceAct;
import com.yy.platform.baseservice.notify.ReportServiceActRtt;
import com.yy.platform.baseservice.notify.ReportServiceCount;
import com.yy.platform.baseservice.notify.ReportServiceRtt;
import com.yy.platform.baseservice.storage.ShareStore;

import java.util.Map;

public final class StatisReporter implements IChannelListener.IServiceHiidoMetricsStatisApi {

    private static StatisReporter sInstance = null;
    private boolean mDefaultHiidoApi = true;
    private IChannelListener.IServiceHiidoMetricsStatisApi mMetricsHiidoApi = null;
    private long mStatisUid = 0L;

    private HandlerThread mReportThread = null;
    private Handler mReportHandler = null;

    public synchronized static StatisReporter instance() {
        if (sInstance == null) {
            sInstance = new StatisReporter();
        }
        return sInstance;
    }

    private StatisReporter() {
        mReportThread = new HandlerThread("ServiceReporter");
        mReportThread.start();
        mReportHandler = new Handler(mReportThread.getLooper());

        mMetricsHiidoApi = new HiidoApiImpl(mReportHandler, HiidoApiImpl.Region.Overseas);
        mDefaultHiidoApi = true;
    }

    public void setMetricsHiidoApi(IChannelListener.IServiceHiidoMetricsStatisApi api) {
        if (api != null) {
            mMetricsHiidoApi = api;
            mDefaultHiidoApi = false;
        }
    }

    public void setStatisUid(long uid) {
        mStatisUid = uid;
    }

    public long getStaticUid() {
        return mStatisUid;
    }

    public void onServiceAct(final ReportServiceAct reportItem) {
        final String hdid = ShareStore.INSTANCE.getHdId();
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    for (ReportItem.ServiceActKeyItem item : reportItem.mKeyFields) {
                        item.mStringFields.put("hdid", hdid);
                        mMetricsHiidoApi.reportStatisticContentTemporary(reportItem.mAct,
                                item.mIntFields, item.mLongFields,
                                item.mStringFields);
                    }
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }

    public void onServiceActRtt(final ReportServiceActRtt reportActItem) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    ReportServiceRtt reportItem = reportActItem.mRtt;
                    if (mDefaultHiidoApi && ("ystap".equals(reportActItem.mAct.mAct)
                            || "ystsvclogin".equals(reportActItem.mAct.mAct))) {
                        ((HiidoApiImpl) mMetricsHiidoApi).reportReturnCodeTemporary(reportItem.mScode,
                                reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                    } else {
                        mMetricsHiidoApi.reportReturnCode(reportItem.mScode, reportItem.mRttUri,
                                reportItem.mRtt, reportItem.mRttCode);

                    }
                    onServiceAct(reportActItem.mAct);
                } catch (Throwable e) {
                    return;
                }

            }
        });
    }

    public void onServiceRtt(final ReportServiceRtt reportItem) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    mMetricsHiidoApi.reportReturnCode(reportItem.mScode,
                            reportItem.mRttUri, reportItem.mRtt, reportItem.mRttCode);
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }

    public void onServiceCount(final ReportServiceCount reportItem) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    for (int i = 0; i < reportItem.mCountImtems.length; i++) {
                        mMetricsHiidoApi.reportCount(reportItem.mScode, reportItem.mCountUri,
                                reportItem.mCountImtems[i].mCountName,
                                reportItem.mCountImtems[i].mCount);
                    }
                } catch (Throwable e) {
                    return;
                }

            }
        });
    }

    @Override
    public void reportReturnCode(final int scode, final String uri,
                                 final long timeConsumption, final String code) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    mMetricsHiidoApi.reportReturnCode(scode, uri, timeConsumption, code);
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }

    @Override
    public void reportCount(final int scode, final String uri, final String countName, final long count) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    mMetricsHiidoApi.reportCount(scode, uri, countName, count);
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }

    @Override
    public void reportCount(final int scode, final String uri, final String countName,
                            final long count, final int times) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    mMetricsHiidoApi.reportCount(scode, uri, countName, count, times);
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }

    @Override
    public void reportStatisticContentTemporary(final String act, final Map<String, Integer> intFields,
                                                final Map<String, Long> longFields,
                                                final Map<String, String> stringFields) {
        mReportHandler.post(new Runnable() {
            @Override
            public void run() {
                try {
                    mMetricsHiidoApi.reportStatisticContentTemporary(act,
                            intFields, longFields, stringFields);
                } catch (Throwable e) {
                    return;
                }
            }
        });
    }
}
