package com.yy.platform.baseservice.statis;

import com.yy.platform.baseservice.YYServiceCore;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/**
 * 协议组装类，为了兼容旧版本SDK而加
 *
 * @Description:TODO
 * @author:wsq
 * @time:Nov 25, 2015 1:08:31 PM
 */
public class StatisContent {
    //协议名称
    public static final String ACT = "act";
    //客户端时间
    public static final String TIME = "time";
    //应用appkey
    public static final String APPKEY = "appkey";
    //验证key
    public static final String KEY = "key";

    // To make the pair whose key is ACT be ordered at front.
    protected static final Comparator<String> COMPARATOR = new Comparator<String>() {

        @Override
        public int compare(String o1, String o2) {
            final boolean equals1 = ACT.equals(o1);
            final boolean equals2 = ACT.equals(o2);

            if (!equals1 && !equals2) {
                return o1.compareTo(o2);
            }
            if (!equals1 && equals2) {
                return 1;
            }
            if (equals1 && !equals2) {
                return -1;
            }
            if (equals1 && equals2) {
                return 0;
            }
            return 0;
        }

    };

    // Use have to avoid repeated pair added.
    protected TreeMap<String, String> raw = new TreeMap<String, String>(
            COMPARATOR);

    /**
     * Put key value pair. Same effect as {@link #put(String, String)} with
     * arguments : (key, String.valueOf(value)).
     *
     * @param key   Cannot be null.
     * @param value An integer. Will be converted as String :
     *              String.valueOf(value).
     * @return Old value if there is for the key, null otherwise.
     */
    public String put(String key, int value) {
        return put(key, String.valueOf(value));
    }

    /**
     * Put key value pair. Same effect as {@link #put(String, String)} with
     * arguments : (key, String.valueOf(value)).
     *
     * @param key   Cannot be null.
     * @param value An integer. Will be converted as String :
     *              String.valueOf(value).
     * @return Old value if there is for the key, null otherwise.
     */
    public String put(String key, long value) {
        return put(key, String.valueOf(value));
    }

    public String put(String key, double value) {
        return put(key, String.valueOf(value));
    }

    public String get(String key) {
        return raw.get(key);
    }

    public boolean containsKey(String key) {
        return raw.containsKey(key);
    }

    /**
     * @param key   Cannot be null.
     * @param value null-OK, null will be converted to empty automatically.
     * @return Old value.
     */
    public synchronized String put(String key, String value) {
        if (Util.empty(key)) {
            YYServiceCore.log(String.format("report key is invalid for value %s", value));
            return null;
        }

        value = Util.asEmptyOnNull(value);

        return raw.put(key, value);

    }

    public synchronized String put(String key, String value, boolean isCover) {
        if (Util.empty(key)) {
            YYServiceCore.log(String.format("report key is invalid for value %s", value));
            return null;
        }

        value = Util.asEmptyOnNull(value);
        if (isCover) {
            return raw.put(key, value);
        } else {
            if (raw.containsKey(key)) {
                return raw.get(key);
            } else {
                return raw.put(key, value);
            }
        }

    }

    /**
     * Get content as URL content. i.e. : the url encoding form of
     * key0=value0&key1=value1, which will be uploaded to server.
     *
     * @return Url encoded.
     */
    public synchronized String getContent() {
        StringBuilder sb = new StringBuilder();

        final TreeMap<String, String> localRaw = raw;

        for (Map.Entry<String, String> e : localRaw.entrySet()) {
            final String value = e.getValue();
            if (Util.empty(value)) {
                YYServiceCore.log(String.format("report No value for key %s", e.getKey()));
                continue;
            }
            sb.append(e.getKey());
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            } catch (UnsupportedEncodingException e1) {
                YYServiceCore.log(String.format("report encoding fail for key %s", e.getKey()));
            }
            sb.append("&");
        }
        if (sb.length() == 0) {
            YYServiceCore.log(String.format("report Warn : http content may be null?"));
            sb = null;
            return null;
        }
        //为了防止在网络传输过程中，后面追加了一些乱七八糟的东西，故随便在后面加一个无用的参数
        if (sb.length() > 0) {
            sb.append("hd_p=E&");
        }

        sb.replace(sb.length() - 1, sb.length(), "");
        String tmp = sb.toString();
        sb.setLength(0);
        sb = null;
//        YYServiceCore.log(String.format("report content=%s",tmp));
        return tmp;
    }

    @Override
    public String toString() {
        return getContent();
    }

    public boolean isEmpty() {
        return raw.isEmpty();
    }

    public StatisContent copy() {
        StatisContent dest = new StatisContent();
        dest.raw = new TreeMap<String, String>(COMPARATOR);
        dest.raw.putAll(raw);
        return dest;
    }
}
