package com.yy.platform.baseservice.profile;

public interface LogProfile {
    interface Printer {
        //由App提供接口打log
        int App = 1;
        //由SDK将log写到App指定的路径
        int SdkToAppProvideDir = 2;
        //由SDK将log写到Applicaition的缓存目录
        int SdkToAppInstallDir = 3;
    }

    interface ILog {
        /**
         * 日志输出接口
         *
         * @param log 日志消息，带所产生时的时间戳和线程前缀
         */
        void outputLog(String log);
    }

    /**
     * 日志接口提供着，若返回值不为空则由App业务层打log
     *
     * @return
     */
    ILog getLog();

    /**
     * 业务指定SDK写log到的目录，
     * 在上述getLog()接口返回null时通过此方法返回一个路径给SDK写日志，
     * 若此方法返回null并且getLog()也返回null，则有SDK将日志写到App的缓存目录
     *
     * @return
     */
    String logPath();

    /**
     * 是否输出到LogCat(Debug Info)
     *
     * @return
     */
    boolean isLogCat();
}
