package com.yy.platform.baseservice.notify;

import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;

public class ReportServiceRtt extends ProtoPacket {

    public int mScode;

    public String mRttUri;
    public String mRttCode;
    public long mRtt;

    public static final long URI = 56;

    public ReportServiceRtt() {
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);

        mScode = popInt();
        mRttUri = popString16("UTF-8");
        mRttCode = popString16("UTF-8");
        mRtt = popInt64();
    }

    @Override
    public void unmarshall(ByteBuffer buf) {
        super.unmarshall(buf);

        mScode = popInt();
        mRttUri = popString16("UTF-8");
        mRttCode = popString16("UTF-8");
        mRtt = popInt64();
    }
}
