/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.util.tree;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.util.tree.TreeIF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNode<T extends TreeIF<T>> {
    private static Logger logger = LoggerFactory.getLogger(TreeNode.class);
    private String treeId;
    private Integer ownerId;
    private Integer parentId;
    @JSONField(name="@timestamp")
    private String timeStamp;
    private T msgNode;

    public TreeNode() {
    }

    public TreeNode(Integer ownerId, Integer parentId, T msgNode) {
        this.ownerId = ownerId;
        this.parentId = parentId;
        this.msgNode = msgNode;
    }

    public List<T> restoreMultiTree(List<JSONObject> list, Class<T> targetClz) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        List<TreeNode<T>> beanList = this.jsonToObject(list, targetClz);
        HashMap<String, ArrayList<TreeNode<T>>> map = new HashMap<String, ArrayList<TreeNode<T>>>();
        for (TreeNode<T> node : beanList) {
            String myTreeId = node.getTreeId();
            ArrayList<TreeNode<T>> oneTree = (ArrayList<TreeNode<T>>)map.get(myTreeId);
            if (oneTree == null) {
                oneTree = new ArrayList<TreeNode<T>>();
                map.put(myTreeId, oneTree);
            }
            oneTree.add(node);
        }
        for (String key : map.keySet()) {
            List oneTree = (List)map.get(key);
            T item = this.buildTree(oneTree);
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public T restore(List<JSONObject> list, Class<T> targetClz) throws Exception {
        List<TreeNode<T>> beanList = this.jsonToObject(list, targetClz);
        return this.buildTree(beanList);
    }

    public List<TreeNode<T>> jsonToObject(List<JSONObject> list, Class<T> targetClz) {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        for (JSONObject json : list) {
            JSONObject newJsonData = (JSONObject)json.clone();
            TreeIF msgNode = (TreeIF)newJsonData.getJSONObject("msgNode").toJavaObject(targetClz);
            newJsonData.remove((Object)"msgNode");
            TreeNode treeNode = (TreeNode)JSON.parseObject((String)newJsonData.toString(), this.getClass());
            treeNode.setMsgNode(msgNode);
            result.add(treeNode);
        }
        return result;
    }

    public String[] split(T tree) {
        String treeId;
        this.treeId = treeId = UUID.randomUUID().toString().replaceAll("-", "");
        return this.splitTreeToJson(tree, treeId);
    }

    public String[] split(T tree, String treeId) {
        this.treeId = treeId;
        return this.splitTreeToJson(tree, treeId);
    }

    public List<TreeNode<T>> splitTree(T tree, String treeId) {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        int lastId = 0;
        int parent = 0;
        TreeNode<T> node = new TreeNode<T>(lastId, -1, tree);
        result.add(node);
        List children = tree.getChildren();
        if (children != null) {
            for (TreeIF treeIF : children) {
                lastId = this.encodeItem(treeIF, lastId, parent, 1, result);
            }
        }
        for (TreeNode treeNode : result) {
            treeNode.setTreeId(treeId);
        }
        return result;
    }

    public String[] splitTreeToJson(T tree, String treeId) {
        List<TreeNode<T>> result = this.splitTree(tree, treeId);
        ArrayList<String> jsons = new ArrayList<String>(result.size());
        String time = DateFormatUtils.formatUTC((long)tree.acquireOriginalCreateTime(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        for (TreeNode<T> node : result) {
            node.setTimeStamp(time);
            List children = node.getMsgNode().getChildren();
            node.getMsgNode().setChildren(null);
            jsons.add(JSONObject.toJSONString(node));
            node.getMsgNode().setChildren(children);
        }
        String[] jsonArray = new String[jsons.size()];
        jsons.toArray(jsonArray);
        return jsonArray;
    }

    public List<TreeNode<T>> splitTreeToJava(T tree, String treeId) {
        this.treeId = treeId;
        List<TreeNode<T>> result = this.splitTree(tree, treeId);
        ArrayList<TreeNode<T>> treeNodes = new ArrayList<TreeNode<T>>(result.size());
        String time = DateFormatUtils.formatUTC((long)tree.acquireOriginalCreateTime(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        for (TreeNode<T> node : result) {
            node.setTimeStamp(time);
            List children = node.getMsgNode().getChildren();
            node.getMsgNode().setChildren(null);
            treeNodes.add(node);
            node.getMsgNode().setChildren(children);
        }
        return treeNodes;
    }

    public int encodeItem(T item, int id, int parent, int level, List<TreeNode<T>> result) {
        int lastId = id + 1;
        TreeNode<T> node = new TreeNode<T>(lastId, parent, item);
        result.add(node);
        List children = item.getChildren();
        if (children != null) {
            parent = lastId;
            for (TreeIF child : children) {
                lastId = this.encodeItem(child, lastId, parent, level + 1, result);
            }
        }
        return lastId;
    }

    public T buildTree(List<TreeNode<T>> list) throws Exception {
        Collections.sort(list, new Comparator<TreeNode<T>>(){

            @Override
            public int compare(TreeNode<T> o1, TreeNode<T> o2) {
                if (o1.getParentId() == o2.getParentId()) {
                    return o1.getOwnerId() - o2.getOwnerId();
                }
                return o1.getParentId() - o2.getParentId();
            }
        });
        HashMap<Integer, TreeNode<T>> map = new HashMap<Integer, TreeNode<T>>();
        for (TreeNode<T> node : list) {
            map.put(node.getOwnerId(), node);
        }
        T result = null;
        if (list.size() > 0) {
            for (TreeNode<T> node : list) {
                Object msgNode = node.getMsgNode();
                Integer parentId = node.getParentId();
                msgNode.setChildren(new ArrayList());
                msgNode.setTreeNode(node);
                if (parentId != -1) {
                    TreeNode node2 = (TreeNode)map.get(parentId);
                    if (node2 == null) {
                        String errorMsg = "parentId not found parentId=" + parentId + " ownId=" + node.getOwnerId() + " treeId=" + node.getTreeId();
                        logger.error(errorMsg);
                        return null;
                    }
                    List children = node2.getMsgNode().getChildren();
                    children.add(msgNode);
                    continue;
                }
                result = (T)msgNode;
            }
        }
        return result;
    }

    public void printItem(T item, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("--");
        }
        System.out.println(item.toString());
        List children = item.getChildren();
        if (children != null) {
            for (TreeIF child : children) {
                this.printItem(child, level + 1);
            }
        }
    }

    public String toString() {
        return "TreeNode [treeId=" + this.treeId + ", ownerId=" + this.ownerId + ", parantId=" + this.parentId + ", msgNode=" + this.msgNode + "]";
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public T getMsgNode() {
        return this.msgNode;
    }

    public void setMsgNode(T msgNode) {
        this.msgNode = msgNode;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }
}

