/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.util;

import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import com.yy.aomi.common.model.proto.ModelStatInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UriSortUtil {
    private static final Logger logger = LoggerFactory.getLogger(UriSortUtil.class);

    public static void sortUriAlarmByThreadUseRate(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getThreadUseRate() > o2.getThreadUseRate()) {
                    return -1;
                }
                if (o1.getThreadUseRate() < o2.getThreadUseRate()) {
                    return 1;
                }
                return 0;
            });
        }
    }

    public static void sortUriAlarmByPercent(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getPercent() > o2.getPercent()) {
                    return -1;
                }
                if (o1.getPercent() < o2.getPercent()) {
                    return 1;
                }
                return 0;
            });
        }
    }

    public static void sortUriAlarmByAvgTime(List<UriInvokeInfo> uriInvokeInfoList) {
        if (!CollectionUtils.isEmpty(uriInvokeInfoList)) {
            Collections.sort(uriInvokeInfoList, (o1, o2) -> {
                if (o1.getAvgTime() > o2.getAvgTime()) {
                    return -1;
                }
                if (o1.getAvgTime() < o2.getAvgTime()) {
                    return 1;
                }
                return 0;
            });
        }
    }

    public static void sortUriStatByThreadUseRate(List<ModelStatInfo> statInfoList) {
        if (!CollectionUtils.isEmpty(statInfoList)) {
            Collections.sort(statInfoList, (o1, o2) -> {
                if (o1.getThreadUseRate() > o2.getThreadUseRate()) {
                    return -1;
                }
                if (o1.getThreadUseRate() < o2.getThreadUseRate()) {
                    return 1;
                }
                return 0;
            });
        }
    }

    public static List<UriInvokeInfo> getSortUriAlarmByUri(List<UriInvokeInfo> uriInvokeInfoList) {
        if (CollectionUtils.isEmpty(uriInvokeInfoList)) {
            return uriInvokeInfoList;
        }
        LinkedList<UriInvokeInfo> newList = new LinkedList<UriInvokeInfo>();
        for (int i = 0; i < uriInvokeInfoList.size(); ++i) {
            UriInvokeInfo vo1 = uriInvokeInfoList.get(i);
            int splitIndex = vo1.getUri().indexOf("+");
            String vo1UriCompareStr = vo1.getUri() + "+";
            boolean isFound = false;
            if (splitIndex < 0) {
                for (int j = 0; j < newList.size(); ++j) {
                    UriInvokeInfo vo2 = (UriInvokeInfo)newList.get(j);
                    if (!vo2.getUri().startsWith(vo1UriCompareStr)) continue;
                    newList.add(j, vo1);
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                newList.add(vo1);
                continue;
            }
            String[] uris = null;
            for (int j = newList.size() - 1; j >= 0; --j) {
                UriInvokeInfo vo2 = (UriInvokeInfo)newList.get(j);
                String vo2UriCompareStr = vo2.getUri() + "+";
                if (vo1.getUri().startsWith(vo2UriCompareStr)) {
                    if (uris == null) {
                        uris = vo1.getUri().split("\\+");
                    }
                    int lastChildOfVo2 = -1;
                    for (int h = newList.size() - 1; h > j; --h) {
                        UriInvokeInfo vo3 = (UriInvokeInfo)newList.get(h);
                        String[] otherUris = vo3.getUri().split("\\+");
                        if (lastChildOfVo2 == -1 && vo3.getUri().startsWith(vo2UriCompareStr)) {
                            lastChildOfVo2 = h;
                        }
                        if (uris.length > otherUris.length) continue;
                        int end = uris.length - 1;
                        boolean isOnlyLastNotEq = true;
                        for (int l = 0; l < end; ++l) {
                            if (otherUris[l].equals(uris[l])) continue;
                            isOnlyLastNotEq = false;
                            break;
                        }
                        if (isOnlyLastNotEq) {
                            boolean bl = isOnlyLastNotEq = !otherUris[end].equals(uris[end]);
                        }
                        if (!isOnlyLastNotEq) continue;
                        isFound = true;
                        newList.add(h + 1, vo1);
                        break;
                    }
                    if (isFound) break;
                    if (lastChildOfVo2 > -1) {
                        newList.add(lastChildOfVo2 + 1, vo1);
                    } else {
                        newList.add(j + 1, vo1);
                    }
                    isFound = true;
                    break;
                }
                if (!vo2.getUri().startsWith(vo1UriCompareStr)) continue;
                for (int h = 0; h < j; ++h) {
                    UriInvokeInfo vo3 = (UriInvokeInfo)newList.get(h);
                    if (!vo3.getUri().startsWith(vo1UriCompareStr)) continue;
                    isFound = true;
                    newList.add(h, vo1);
                    break;
                }
                if (isFound) break;
                isFound = true;
                newList.add(j, vo1);
                break;
            }
            if (isFound) continue;
            newList.add(vo1);
        }
        return newList;
    }

    public static void main(String[] args) {
        ArrayList<UriInvokeInfo> uriInvokeInfoList = new ArrayList<UriInvokeInfo>();
        UriInvokeInfo alarm = new UriInvokeInfo("a", 4L, 1L, 0L, 0L, "");
        alarm.setThreadUseRate(100.0);
        UriInvokeInfo alarm1 = new UriInvokeInfo("a+b", 5L, 2L, 0L, 0L, "");
        alarm1.setThreadUseRate(40.0);
        UriInvokeInfo alarm4 = new UriInvokeInfo("a+b+c", 6L, 3L, 0L, 0L, "");
        alarm4.setThreadUseRate(40.0);
        UriInvokeInfo alarm2 = new UriInvokeInfo("a+c", 7L, 4L, 0L, 0L, "");
        alarm2.setThreadUseRate(30.0);
        UriInvokeInfo alarm3 = new UriInvokeInfo("a+d", 8L, 5L, 0L, 0L, "");
        alarm3.setThreadUseRate(30.0);
        UriInvokeInfo alarm5 = new UriInvokeInfo("a+d+e", 9L, 6L, 0L, 0L, "");
        alarm5.setThreadUseRate(30.0);
        UriInvokeInfo alarm6 = new UriInvokeInfo("a+c+d", 0L, 0L, 0L, 0L, "");
        alarm6.setThreadUseRate(30.0);
        UriInvokeInfo alarm7 = new UriInvokeInfo("a+d+e+f", 0L, 0L, 0L, 0L, "");
        alarm7.setThreadUseRate(30.0);
        UriInvokeInfo alarm8 = new UriInvokeInfo("b+c+e", 0L, 0L, 0L, 0L, "");
        alarm8.setThreadUseRate(20.0);
        UriInvokeInfo alarm9 = new UriInvokeInfo("b", 0L, 0L, 0L, 0L, "");
        alarm9.setThreadUseRate(20.0);
        UriInvokeInfo alarm10 = new UriInvokeInfo("b+c+e+f+g", 0L, 0L, 0L, 0L, "");
        alarm10.setThreadUseRate(10.0);
        UriInvokeInfo alarm16 = new UriInvokeInfo("b+c+e+f", 0L, 0L, 0L, 0L, "");
        alarm10.setThreadUseRate(10.0);
        UriInvokeInfo alarm11 = new UriInvokeInfo("b+c+f", 0L, 0L, 0L, 0L, "");
        alarm11.setThreadUseRate(1.0);
        UriInvokeInfo alarm12 = new UriInvokeInfo("b+c", 0L, 0L, 0L, 0L, "");
        alarm12.setThreadUseRate(20.0);
        UriInvokeInfo alarm13 = new UriInvokeInfo("c", 0L, 0L, 0L, 0L, "");
        alarm13.setThreadUseRate(20.0);
        UriInvokeInfo alarm15 = new UriInvokeInfo("c+m+x", 0L, 0L, 0L, 0L, "");
        alarm15.setThreadUseRate(20.0);
        UriInvokeInfo alarm14 = new UriInvokeInfo("c+m", 0L, 0L, 0L, 0L, "");
        alarm14.setThreadUseRate(20.0);
        uriInvokeInfoList.add(alarm15);
        uriInvokeInfoList.add(alarm7);
        uriInvokeInfoList.add(alarm12);
        uriInvokeInfoList.add(alarm);
        uriInvokeInfoList.add(alarm3);
        uriInvokeInfoList.add(alarm9);
        uriInvokeInfoList.add(alarm2);
        uriInvokeInfoList.add(alarm6);
        uriInvokeInfoList.add(alarm5);
        uriInvokeInfoList.add(alarm8);
        uriInvokeInfoList.add(alarm10);
        uriInvokeInfoList.add(alarm11);
        uriInvokeInfoList.add(alarm4);
        uriInvokeInfoList.add(alarm1);
        uriInvokeInfoList.add(alarm14);
        uriInvokeInfoList.add(alarm13);
        uriInvokeInfoList.add(alarm16);
        logger.info("sort before list:");
        UriSortUtil.sortUriAlarmByPercent(uriInvokeInfoList);
        logger.info("sort finish list:{}", uriInvokeInfoList);
    }
}

