/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.util;

import com.yy.aomi.analysis.common.model.analysis.CombUriVo;
import com.yy.aomi.common.util.UriFormatUtil;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class UriParseMethod
implements TemplateMethodModelEx {
    private static final Logger logger = LoggerFactory.getLogger(UriParseMethod.class);

    public Object exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Wrong arguments");
        }
        return new SimpleScalar(UriFormatUtil.formatYypUri((String)((SimpleScalar)args.get(0)).getAsString()));
    }

    public static CombUriVo parseCombUri(boolean isRPC, String combUri) {
        return UriParseMethod.parseCombUri(isRPC, combUri, true);
    }

    public static CombUriVo parseCombUri(boolean isRPC, String combUri, boolean includeHost) {
        CombUriVo vo = new CombUriVo();
        if (!StringUtils.isEmpty((Object)combUri)) {
            if (isRPC) {
                int index;
                String uri = combUri;
                if (includeHost && (index = combUri.lastIndexOf("_")) >= 0) {
                    uri = combUri.substring(0, index);
                    String nextHost = combUri.substring(index + 1);
                    String[] host = nextHost.split(":");
                    if (host.length == 2) {
                        vo.setNextIp(host[0]);
                        vo.setNextPort(Integer.valueOf(host[1]));
                        vo.setNextHost(nextHost);
                    }
                }
                String nextUri = uri.substring(uri.lastIndexOf("+") + 1);
                vo.setUri(uri);
                vo.setNextUri(nextUri);
                vo.setConnNextUri(nextUri);
                vo.setConnUri(vo.getUri());
            } else {
                String uri = combUri;
                int index = combUri.indexOf("+");
                if (index > 0) {
                    uri = uri.substring(0, index);
                }
                vo.setUri(uri);
                vo.setConnUri(uri);
                if (!uri.equals(combUri)) {
                    vo.setNextUri(combUri);
                    vo.setConnNextUri(combUri);
                }
            }
        }
        return vo;
    }
}

