/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.util;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TimeStatScalesUtil {
    public static int getLessThanTimeScaleCount(Map<String, Integer> scales, int maxScaleTime) {
        int count = 0;
        if (MapUtils.isEmpty(scales)) {
            return count;
        }
        for (String oneScale : scales.keySet()) {
            int maxValue = TimeStatScalesUtil.parseMaxValue(oneScale);
            if (maxScaleTime <= maxValue) continue;
            count += scales.get(oneScale).intValue();
        }
        return count;
    }

    public static int getLargeThanTimeScaleCount(Map<String, Integer> scales, long maxScaleTime) {
        int count = 0;
        if (MapUtils.isEmpty(scales)) {
            return count;
        }
        for (String oneScale : scales.keySet()) {
            int maxValue = TimeStatScalesUtil.parseMaxValue(oneScale);
            if (maxScaleTime > (long)maxValue) continue;
            count += scales.get(oneScale).intValue();
        }
        return count;
    }

    public static int parseMaxValue(String oneScale) {
        String maxNumStr = oneScale.substring(oneScale.indexOf(44) + 1, oneScale.indexOf(41));
        int maxValue = 0;
        maxValue = NumberUtils.isDigits((String)maxNumStr) ? Integer.parseInt(maxNumStr) : Integer.MAX_VALUE;
        return maxValue;
    }
}

