/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgChain;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeChain;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeTree;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgProcNode;
import com.yy.aomi.analysis.common.model.alarm.ErrorChainNode;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import com.yy.aomi.common.util.ProcessUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AlarmTreeNodeBuilder {
    static Logger logger = LoggerFactory.getLogger(AlarmTreeNodeBuilder.class);

    public static AlarmMsgNodeTree buildTreeNodeByAlarm(AlarmMsg orgAlarmMsg) {
        try {
            AlarmMsg alarmMsg = orgAlarmMsg.newInstance();
            AlarmMsgChain<AlarmMsg> msgChain = new AlarmMsgChain<AlarmMsg>();
            msgChain.add(alarmMsg);
            AlarmMsgProcNode alarmMsgTreeNode = new AlarmMsgProcNode(msgChain);
            AlarmMsgNodeTree tree = new AlarmMsgNodeTree();
            tree.setRoot(alarmMsgTreeNode);
            return tree;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static TreeNode<ErrorChainNode> buildErrorChainTreeNode(AlarmMsgNodeTree tree) {
        int errorProcCount = tree.calErrorCount();
        int procCount = tree.calProcCount();
        if (procCount > 1) {
            tree.setAnalyseType(2);
        } else {
            tree.setAnalyseType(1);
        }
        String treeId = AlarmTreeNodeBuilder.generateUniqueId();
        tree.setTreeId(treeId);
        TreeNode<ErrorChainNode> treeNode = new TreeNode<ErrorChainNode>(){};
        try {
            ErrorChainNode errorChainNode;
            ErrorChainNode errorNode = errorChainNode = AlarmTreeNodeBuilder.buildErrorChainNodeList(tree.getRoot().getAlarmMsg(), tree.getAnalyseType());
            for (AlarmMsgNodeChain chain : tree.getChildren()) {
                for (AlarmMsgProcNode node : chain) {
                    for (AlarmMsg alarmMsg : node.getMsgChain()) {
                        ArrayList<ErrorChainNode> chainNodeList = new ArrayList<ErrorChainNode>();
                        ErrorChainNode tmpErrorNode = AlarmTreeNodeBuilder.buildErrorChainNodeList(alarmMsg, tree.getAnalyseType());
                        chainNodeList.add(tmpErrorNode);
                        errorNode.setChildren((List<ErrorChainNode>)chainNodeList);
                        errorNode = tmpErrorNode;
                    }
                }
            }
            errorChainNode.setProcCount(errorProcCount);
            treeNode.setTreeId(treeId);
            treeNode.setMsgNode(errorChainNode);
            errorChainNode.setTreeNode(treeNode);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        tree.getRoot().getAlarmMsg().setTreeId(treeId);
        return treeNode;
    }

    private static ErrorChainNode buildErrorChainNodeList(AlarmMsg alarmMsg, int analyseType) throws Exception {
        ErrorChainNode errorChainNode = new ErrorChainNode();
        BeanUtils.copyProperties((Object)alarmMsg, (Object)errorChainNode);
        errorChainNode.setMsgId(AlarmTreeNodeBuilder.generateUniqueId());
        errorChainNode.setBeginTime(alarmMsg.getBeginTime());
        errorChainNode.setEndTime(alarmMsg.getReportTime());
        if (alarmMsg.getApp() != null) {
            errorChainNode.setAppName(alarmMsg.getApp().getClientname());
            errorChainNode.setPorts(String.valueOf(alarmMsg.getApp().defaultPort()));
            errorChainNode.setIps(alarmMsg.getApp().defaultIp());
            errorChainNode.setOrgIps(ProcessUtil.parseIps(alarmMsg.getApp().getIpList()));
            errorChainNode.setOrgPorts(ProcessUtil.parsePorts(alarmMsg.getApp().getPortList()));
            errorChainNode.setBusinessId(alarmMsg.getApp().getBusinessid());
        }
        if (alarmMsg.getContext() != null) {
            errorChainNode.setCtx((JSONObject)JSON.toJSON((Object)alarmMsg.getContext()));
        }
        errorChainNode.setAnalyseType(analyseType);
        if (alarmMsg.hasChildren()) {
            ArrayList<ErrorChainNode> children = new ArrayList<ErrorChainNode>();
            for (AlarmMsg child : alarmMsg.getChildren()) {
                if (child.getApp() == null) {
                    child.setApp(alarmMsg.getApp());
                }
                ErrorChainNode childNode = AlarmTreeNodeBuilder.buildErrorChainNodeList(child, analyseType);
                children.add(childNode);
            }
            errorChainNode.setChildren((List<ErrorChainNode>)children);
        }
        return errorChainNode;
    }

    public static String generateUniqueId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

