/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.service;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.dao.mysql.IUniqueIdDao;
import com.yy.aomi.analysis.common.util.TinyUrlDataUtil;
import com.yy.aomi.common.autoconfigure.SystemConf;
import com.yy.aomi.elastic.DateUtils;
import com.yy.aomi.elastic.ESCondition;
import com.yy.aomi.elastic.ElasticSearchImpl;
import java.text.MessageFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TinyUrlService {
    protected static Logger logger = LoggerFactory.getLogger(TinyUrlService.class);
    @Autowired
    private ElasticSearchImpl elkSearchImpl;
    @Autowired
    private IUniqueIdDao uniqueIdDao;
    @Autowired
    private SystemConf systemConf;

    public String getTinyUrlByParams(String url) throws Exception {
        String aomiJumpDemo = this.systemConf.getConf("aomi.jump");
        String tinyId = this.uniqueIdDao.getUniqueId2Base64();
        JSONObject tinyUrlModel = new JSONObject();
        tinyUrlModel.put("tinyId", (Object)tinyId);
        tinyUrlModel.put("uri", (Object)url);
        tinyUrlModel.put("@timestamp", (Object)DateUtils.formatUTCByUTCPattern((Date)new Date()));
        ESCondition condition = new ESCondition(TinyUrlDataUtil.type, new String[]{TinyUrlDataUtil.index});
        condition.setInsertRecords(new String[]{tinyUrlModel.toJSONString()});
        this.elkSearchImpl.insert(condition);
        String aomiJumpUrl = MessageFormat.format(aomiJumpDemo, tinyId);
        return aomiJumpUrl;
    }

    public String getErrorChainTinyUrl(String businessId, String treeId, long begingTime) {
        String result = null;
        if (businessId == null) {
            businessId = "0";
        }
        String errorChainUrlDemo = this.systemConf.getConf("aomi.errorchain.url");
        String url = this.formatString(errorChainUrlDemo, businessId, treeId, begingTime);
        try {
            result = this.getTinyUrlByParams(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("getTinyUrlByParams url={},shortUrl={}", (Object)url, (Object)result);
        return result;
    }

    private String formatString(String demo, Object ... params) {
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            demo = demo.replace("{" + i + "}", params[i].toString());
        }
        return demo;
    }
}

