/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.service;

import com.yy.aomi.analysis.common.dao.http.MachineClient;
import com.yy.aomi.analysis.common.model.ops.MachineQueryModel;
import com.yy.aomi.analysis.common.model.ops.MachineServerInfo;
import com.yy.aomi.common.autoconfigure.SystemConf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MachineMgrService {
    private static final Logger logger = LoggerFactory.getLogger(MachineMgrService.class);
    @Autowired
    private SystemConf systemConf;
    @Autowired
    private MachineClient machineInfo;
    private static final String MACHINE_ROOM_QUERY_URL_KEY = "machine.room.url";
    private static final String DEFAULT_MACHINE_ROOM_QUERY_URL = "http://cmdb.sysop.duowan.com:8088/webservice/server/getServerInfos.do";
    private static final Map<String, MachineServerInfo> machineRoomInfoMap = new ConcurrentHashMap<String, MachineServerInfo>();

    public List<MachineServerInfo> getServerInfos(List<String> queryIpList) {
        ArrayList<MachineServerInfo> machineServerInfoList = new ArrayList<MachineServerInfo>();
        if (CollectionUtils.isEmpty(queryIpList)) {
            return machineServerInfoList;
        }
        Iterator<String> ipIt = queryIpList.iterator();
        while (ipIt.hasNext()) {
            String ip = ipIt.next();
            MachineServerInfo roomInfo = machineRoomInfoMap.get(ip);
            if (roomInfo == null) continue;
            ipIt.remove();
        }
        if (queryIpList.isEmpty()) {
            return machineServerInfoList;
        }
        List<MachineServerInfo> cmdbMachineServerInfoList = this.getServerInfosFromCmdb(queryIpList);
        for (MachineServerInfo serverInfo : cmdbMachineServerInfoList) {
            machineRoomInfoMap.put(serverInfo.getIp(), serverInfo);
        }
        machineServerInfoList.addAll(cmdbMachineServerInfoList);
        return machineServerInfoList;
    }

    public MachineServerInfo getServerInfo(String ip) {
        List<MachineServerInfo> machineServerInfos = this.getServerInfos(ip);
        if (!machineServerInfos.isEmpty()) {
            return machineServerInfos.get(0);
        }
        return null;
    }

    public List<MachineServerInfo> getServerInfos(String ips) {
        ArrayList<MachineServerInfo> machineServerInfoList = new ArrayList<MachineServerInfo>();
        if (StringUtils.isEmpty((CharSequence)ips)) {
            return machineServerInfoList;
        }
        String[] ipArry = ips.split(",");
        ArrayList<String> queryIpList = new ArrayList<String>();
        for (String ip : ipArry) {
            MachineServerInfo roomInfo = machineRoomInfoMap.get(ip);
            if (roomInfo != null) {
                machineServerInfoList.add(roomInfo);
                continue;
            }
            queryIpList.add(ip);
        }
        if (queryIpList.isEmpty()) {
            return machineServerInfoList;
        }
        List<MachineServerInfo> cmdbMachineServerInfoList = this.getServerInfosFromCmdb(queryIpList);
        for (MachineServerInfo serverInfo : cmdbMachineServerInfoList) {
            machineRoomInfoMap.put(serverInfo.getIp(), serverInfo);
        }
        machineServerInfoList.addAll(cmdbMachineServerInfoList);
        return machineServerInfoList;
    }

    public List<MachineServerInfo> getServerInfosFromCmdb(List<String> queryIpList) {
        String queryIps = StringUtils.join(queryIpList, (String)",");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ip", queryIps);
        Object content = null;
        int tryTime = 3;
        MachineQueryModel queryModel = null;
        while (tryTime-- >= 0) {
            try {
                queryModel = this.machineInfo.getServerInfos(queryIps);
                break;
            }
            catch (Exception e) {
                if (tryTime == 0) {
                    logger.info("get /webservice/server/getServerInfos.do?ip={ip}  error,ip={}", (Object)queryIps);
                    break;
                }
                logger.info("get /webservice/server/getServerInfos.do?ip={ip}  error,ip={} ,try 3 times tryTime={}", (Object)queryIps, (Object)tryTime);
            }
        }
        if (queryModel != null && queryModel.isSuccess() && queryModel.getObject() != null) {
            return queryModel.getObject();
        }
        return Collections.emptyList();
    }
}

