/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.service;

import com.alibaba.fastjson.JSON;
import com.yy.aomi.analysis.common.constant.AnalysisEsTables;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeTree;
import com.yy.aomi.analysis.common.model.alarm.ErrorChainNode;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import com.yy.aomi.analysis.common.service.AlarmMsgFormatService;
import com.yy.aomi.analysis.common.service.TinyUrlService;
import com.yy.aomi.analysis.common.util.AlarmTreeNodeBuilder;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import com.yy.aomi.common.model.EventMessage;
import com.yy.aomi.elastic.ESCondition;
import com.yy.aomi.elastic.ElasticSearchImpl;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AlarmService {
    private static final Logger logger = LoggerFactory.getLogger(AlarmService.class);
    public static final String PROCESS_ERROR_TAG = "processError";
    public static final String SOURCE_ERROR_TAG = "sourceError";
    @Autowired
    private ElasticSearchImpl elkSearchImpl;
    @Autowired
    private TinyUrlService tinyUrlService;
    @Autowired
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private AlarmMsgFormatService formatService;
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(5);

    public String asyncSingleProcessorAlarm(AlarmMsg alarmMsg) {
        MonitorAppInfo appInfo = alarmMsg.getApp();
        if (Objects.isNull((Object)appInfo) || Objects.isNull(alarmMsg)) {
            return null;
        }
        AlarmMsgNodeTree tree = AlarmTreeNodeBuilder.buildTreeNodeByAlarm(alarmMsg);
        if (tree == null) {
            return null;
        }
        return this.alarm(tree, PROCESS_ERROR_TAG);
    }

    public String asyncMultiProcessorAlarm(AlarmMsgNodeTree tree) {
        return this.alarm(tree, SOURCE_ERROR_TAG);
    }

    public String alarm(AlarmMsgNodeTree tree, String analysisType) {
        if (Objects.isNull(tree) || Objects.isNull(tree.getRoot()) || Objects.isNull(tree.getRoot().getAlarmMsg())) {
            return null;
        }
        MessageBuildResult result = this.buildMessage(tree, analysisType);
        if (tree.getRoot().getAlarmMsg().getErrorType() != 34) {
            this.sendToKafka(result.messages);
        }
        this.saveEventAnalysis(result.messages.get(0), result.treeNode);
        return result.treeNode.getTreeId();
    }

    private MessageBuildResult buildMessage(AlarmMsgNodeTree tree, String analysisType) {
        TreeNode<ErrorChainNode> treeNode = AlarmTreeNodeBuilder.buildErrorChainTreeNode(tree);
        String url = null;
        ErrorChainNode node = treeNode.getMsgNode();
        if (!StringUtils.isEmpty((Object)treeNode.getTreeId()) && !StringUtils.isEmpty((Object)node.getBusinessId()) && node.acquireOriginalCreateTime() > 0L) {
            url = this.tinyUrlService.getErrorChainTinyUrl(node.getBusinessId(), treeNode.getTreeId(), node.acquireOriginalCreateTime());
        }
        List<EventMessage> messageList = this.formatService.formatSmsMsg(tree, analysisType, url);
        return new MessageBuildResult(treeNode, messageList);
    }

    private void saveEventAnalysis(EventMessage message, TreeNode<ErrorChainNode> treeNode) {
        try {
            String[] chainNodes;
            treeNode.getMsgNode().setCharge(message.getCharge());
            for (String info : chainNodes = treeNode.split(treeNode.getMsgNode(), treeNode.getTreeId())) {
                logger.info("insert error msg={}", (Object)info);
            }
            Date reportDate = new Date(treeNode.getMsgNode().getEndTime());
            String index = AnalysisEsTables.ERROR_CHAIN.getTimeIndex(reportDate);
            String esTypeName = AnalysisEsTables.ERROR_CHAIN.getType();
            logger.info("alarm saveAlarmToEs list.size={}", (Object)chainNodes.length);
            EXECUTOR.submit(new EsSaveTaskItem(ESCondition.getInsertEntity((String)index, (String)esTypeName, (String[])chainNodes)));
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
    }

    private void sendToKafka(List<EventMessage> messageList) {
        for (EventMessage message : messageList) {
            String msg = JSON.toJSONString((Object)message);
            logger.info("sendToKafka msg={} ", (Object)msg);
            try {
                this.kafkaTemplate.sendDefault((Object)message.getReduceBy(), (Object)msg);
            }
            catch (Throwable e) {
                logger.error("send kafka inhibitKey=" + message.getReduceBy() + ",error=" + e, e);
            }
        }
    }

    class EsSaveTaskItem
    implements Callable<ESCondition> {
        private ESCondition params;

        public EsSaveTaskItem(ESCondition params) {
            this.params = params;
        }

        @Override
        public ESCondition call() throws Exception {
            AlarmService.this.elkSearchImpl.insert(this.params);
            return null;
        }
    }

    public static class MessageBuildResult {
        TreeNode<ErrorChainNode> treeNode;
        List<EventMessage> messages;

        public MessageBuildResult(TreeNode<ErrorChainNode> treeNode, List<EventMessage> messages) {
            this.treeNode = treeNode;
            this.messages = messages;
        }
    }
}

