/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.service;

import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.QueueBlockAlarm;
import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import com.yy.aomi.analysis.common.util.ThreadAnalysisUtil;
import com.yy.aomi.analysis.common.util.UriSortUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlarmMsgMergeService {
    public List<AlarmMsg> mergeSameLevelErrorInfo(AlarmMsg alarmMsg, AlarmMsg nextAlarmMsg, int topCount) throws Exception {
        ArrayList<AlarmMsg> mergeAlarmMsgList = new ArrayList<AlarmMsg>();
        if (alarmMsg != null && nextAlarmMsg != null) {
            if (alarmMsg.getClass().equals(nextAlarmMsg.getClass())) {
                List<AlarmMsg> children = alarmMsg.getChildren();
                List<AlarmMsg> nextChildren = nextAlarmMsg.getChildren();
                boolean firstIsEmpty = CollectionUtils.isEmpty(children);
                boolean nexIsEmpty = CollectionUtils.isEmpty(nextChildren);
                AlarmMsg mergeAlarmMsg = nextAlarmMsg.newInstance();
                mergeAlarmMsg.setChildren(new ArrayList<AlarmMsg>());
                if (!firstIsEmpty || !nexIsEmpty) {
                    int maxIndex = children.size() > nextChildren.size() ? children.size() : nextChildren.size();
                    for (int n = 0; n < maxIndex; ++n) {
                        AlarmMsg child = null;
                        AlarmMsg nextChild = null;
                        if (n < children.size()) {
                            child = children.get(n);
                        }
                        if (n < nextChildren.size()) {
                            nextChild = nextChildren.get(n);
                        }
                        List<AlarmMsg> alarmMsgList = this.mergeSameLevelErrorInfo(child, nextChild, topCount);
                        mergeAlarmMsg.addAll(alarmMsgList);
                    }
                }
                ArrayList<AlarmMsg> mergeList = new ArrayList<AlarmMsg>();
                mergeList.add(alarmMsg);
                mergeList.add(nextAlarmMsg);
                if (alarmMsg.getBeginTime() < nextAlarmMsg.getBeginTime()) {
                    mergeAlarmMsg.setBeginTime(alarmMsg.getBeginTime());
                }
                if (alarmMsg.getReportTime() > nextAlarmMsg.getReportTime()) {
                    mergeAlarmMsg.setReportTime(alarmMsg.getReportTime());
                }
                this.mergeSameErrorUriStatInfo(mergeAlarmMsg, mergeList, topCount);
                mergeAlarmMsg.setIsMerge(true);
                mergeAlarmMsgList.add(mergeAlarmMsg);
            } else {
                this.sortAlarmUriList(alarmMsg, alarmMsg.getUriList(), topCount);
                this.sortAlarmUriList(nextAlarmMsg, nextAlarmMsg.getUriList(), topCount);
                mergeAlarmMsgList.add(alarmMsg);
                mergeAlarmMsgList.add(nextAlarmMsg);
            }
            return mergeAlarmMsgList;
        }
        if (alarmMsg != null) {
            this.sortAlarmUriList(alarmMsg, alarmMsg.getUriList(), topCount);
            mergeAlarmMsgList.add(alarmMsg);
        } else if (nextAlarmMsg != null) {
            this.sortAlarmUriList(nextAlarmMsg, nextAlarmMsg.getUriList(), topCount);
            mergeAlarmMsgList.add(nextAlarmMsg);
        }
        return mergeAlarmMsgList;
    }

    public AlarmMsg mergeSameErrorUriStatInfo(AlarmMsg mergeAlarmMsg, List<AlarmMsg> alarmMsgList, int topCount) throws Exception {
        HashMap<String, UriInvokeInfo> uriTimeoutAlarmMap = new HashMap<String, UriInvokeInfo>();
        for (AlarmMsg alarmMsg : alarmMsgList) {
            List<UriInvokeInfo> topUriStatList = alarmMsg.getUriList();
            for (UriInvokeInfo uta : topUriStatList) {
                UriInvokeInfo uriSta = (UriInvokeInfo)uriTimeoutAlarmMap.get(uta.getUri());
                if (uriSta == null) {
                    uriSta = new UriInvokeInfo(uta.getUri(), uta.getCount(), uta.getErrorCount(), uta.getTotalTime(), uta.getThProcTl(), uta.getRpcHost());
                    uriTimeoutAlarmMap.put(uta.getUri(), uriSta);
                    continue;
                }
                uriSta.setCount(uta.getCount() + uriSta.getCount());
                uriSta.setErrorCount(uta.getErrorCount() + uriSta.getErrorCount());
                uriSta.setTotalTime(uta.getTotalTime() + uriSta.getTotalTime());
                if (uta.getCount() > 0L) {
                    uriSta.setAvgTime(uta.getTotalTime() / uta.getCount());
                }
                uriSta.setThProcTl(uta.getThProcTl() + uriSta.getThProcTl());
            }
        }
        ArrayList<UriInvokeInfo> uriInvokeInfoList = new ArrayList<UriInvokeInfo>();
        for (UriInvokeInfo uriAlarm : uriTimeoutAlarmMap.values()) {
            uriInvokeInfoList.add(uriAlarm);
        }
        if (mergeAlarmMsg instanceof QueueBlockAlarm) {
            QueueBlockAlarm queueBlockAlarm = (QueueBlockAlarm)mergeAlarmMsg;
            long threadUseTotalTime = queueBlockAlarm.queue().getThreadTotalTime();
            for (UriInvokeInfo uriAlarm : uriInvokeInfoList) {
                uriAlarm.setThreadUseRate(ThreadAnalysisUtil.getThreadUseRate(uriAlarm.getThProcTl(), threadUseTotalTime));
            }
        }
        this.sortAlarmUriList(mergeAlarmMsg, uriInvokeInfoList, topCount);
        long l = 0L;
        long totalErrorCount = 0L;
        for (UriInvokeInfo uriInvokeInfo : uriInvokeInfoList) {
            l += uriInvokeInfo.getCount();
            totalErrorCount += uriInvokeInfo.getErrorCount();
        }
        mergeAlarmMsg.setErrorCount(totalErrorCount);
        mergeAlarmMsg.setTotalCount(l);
        return mergeAlarmMsg;
    }

    public void sortAlarmUriList(AlarmMsg mergeAlarmMsg, List<UriInvokeInfo> uriInvokeInfoList, int topCount) {
        if (uriInvokeInfoList.size() > 1) {
            if (mergeAlarmMsg instanceof QueueBlockAlarm) {
                UriSortUtil.sortUriAlarmByThreadUseRate(uriInvokeInfoList);
            } else {
                UriSortUtil.sortUriAlarmByAvgTime(uriInvokeInfoList);
            }
            if (uriInvokeInfoList.size() < topCount) {
                topCount = uriInvokeInfoList.size();
            }
            List<UriInvokeInfo> subList = uriInvokeInfoList.subList(0, topCount);
            mergeAlarmMsg.setUriList(UriSortUtil.getSortUriAlarmByUri(subList));
        } else {
            mergeAlarmMsg.setUriList(uriInvokeInfoList);
        }
    }
}

