/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.service;

import com.yy.aomi.analysis.common.constant.ErrorDefinition;
import com.yy.aomi.analysis.common.dao.mysql.IBusinessSummaryDao;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeChain;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeTree;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgProcNode;
import com.yy.aomi.analysis.common.model.alarm.RpcAlarm;
import com.yy.aomi.analysis.common.model.alarm.UriInvokeInfo;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import com.yy.aomi.analysis.common.model.entity.mysql.BusinessSummary;
import com.yy.aomi.analysis.common.util.UriSortUtil;
import com.yy.aomi.common.constant.EventTypeEm;
import com.yy.aomi.common.constant.ModelType;
import com.yy.aomi.common.model.EventMessage;
import com.yy.aomi.common.util.UriFormatUtil;
import com.yy.aomi.sdk.AomiSdk;
import com.yy.aomi.sdk.process.ProcessInfoCollector;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class AlarmMsgFormatService {
    private static final Logger logger = LoggerFactory.getLogger(AlarmMsgFormatService.class);
    public static String summaryFileName = "summary.ftl";
    public static final String ALARM_APP = "aomi";
    @Autowired
    Configuration configuration;
    @Autowired
    private IBusinessSummaryDao businessSummaryDao;
    private BusinessSummary defaultBusiness;

    public BusinessSummary getDefaultBusinessSummary() {
        if (this.defaultBusiness == null) {
            this.defaultBusiness = new BusinessSummary();
            this.defaultBusiness.setBusiness("\u672a\u77e5\u4e1a\u52a1\u7ebf");
            this.defaultBusiness.setCharge("\u672a\u77e5\u5927\u795e");
            this.defaultBusiness.setCategoryId("0");
        }
        return this.defaultBusiness;
    }

    public List<EventMessage> formatSmsMsg(AlarmMsgNodeTree tree, String analysisType, String url) {
        ArrayList<EventMessage> messageList = new ArrayList<EventMessage>();
        AlarmMsgProcNode treeRootNode = tree.getRoot();
        EventMessage message = this.formatSmsMsg(treeRootNode, analysisType, url);
        if (message != null) {
            String asAppName = this.getAnalysisProcessName();
            if (StringUtils.isNotEmpty((CharSequence)asAppName)) {
                message.getServices().add(asAppName);
            }
            messageList.add(message);
        }
        for (AlarmMsgNodeChain chain : tree.getChildren()) {
            for (AlarmMsgProcNode node : chain) {
                message = this.formatSmsMsg(node, analysisType, url);
                if (message == null) continue;
                messageList.add(message);
            }
        }
        return messageList;
    }

    public EventMessage formatSmsMsg(AlarmMsgProcNode node, String analysisType, String url) {
        AlarmMsg alarmMsg = node.alarmMsg;
        MonitorAppInfo appInfo = node.getApp();
        if (ErrorDefinition.isError(alarmMsg.getErrorType())) {
            String content = "";
            String businessName = "";
            String chargeName = "";
            String percent = "0%";
            BusinessSummary businessSummary = null;
            if (StringUtils.isNotEmpty((CharSequence)appInfo.getBusinessid())) {
                try {
                    businessSummary = this.businessSummaryDao.getByBusinessId(appInfo.getBusinessid());
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (businessSummary == null) {
                businessSummary = this.getDefaultBusinessSummary();
            }
            businessName = businessSummary.getBusiness();
            chargeName = businessSummary.getCharge();
            if (alarmMsg.getTotalCount() > 0L) {
                percent = String.format("%.2f", (double)(alarmMsg.getErrorCount() * 100L) / ((double)alarmMsg.getTotalCount() * 1.0)) + "%";
            }
            HashMap<String, Object> simpleMap = new HashMap<String, Object>();
            simpleMap.put("data", alarmMsg);
            simpleMap.put("procInfo", appInfo.defaultHost() + "(" + appInfo.getClientname() + ")");
            simpleMap.put("rcpProcInfo", AlarmMsgFormatService.getRpcProcInfo(alarmMsg));
            simpleMap.put("business", businessName);
            simpleMap.put("charge", chargeName);
            simpleMap.put("errorRate", percent);
            simpleMap.put("link", url);
            simpleMap.put("top1", AlarmMsgFormatService.topUriSimpleFormat(alarmMsg));
            simpleMap.put("errorTime", DateFormatUtils.format((long)appInfo.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            try {
                content = FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.configuration.getTemplate(summaryFileName), simpleMap);
            }
            catch (Exception e) {
                logger.error("freeMarkerTemplate parse error!", (Throwable)e);
            }
            logger.info("aomi-sms-msg-content=\n {}", (Object)content);
            ArrayList<String> serviceNames = new ArrayList<String>();
            serviceNames.add(appInfo.getClientname());
            String inhibitKey = this.buildReduceKey(node, analysisType);
            EventMessage message = new EventMessage();
            message.setAppId(ALARM_APP);
            message.setCreateTime(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            message.setAlarmTime(DateFormatUtils.format((long)appInfo.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            message.setType(EventTypeEm.ALARM);
            message.setAlarmLevel(node.alarmMsg.getLevel());
            message.setReduceBy(inhibitKey);
            message.setServices(serviceNames);
            message.setUrl(url);
            message.setData(content);
            message.setCharge(chargeName);
            message.setIp(appInfo.defaultIp());
            return message;
        }
        return null;
    }

    public static String topUriSimpleFormat(AlarmMsg alarmMsg) {
        if (CollectionUtils.isEmpty(alarmMsg.getUriList())) {
            return "";
        }
        if (ModelType.isQueue((int)alarmMsg.getModelType())) {
            UriSortUtil.sortUriAlarmByThreadUseRate(alarmMsg.getUriList());
        } else {
            UriSortUtil.sortUriAlarmByPercent(alarmMsg.getUriList());
        }
        UriInvokeInfo top1 = alarmMsg.getUriList().get(0);
        StringBuffer topUri = new StringBuffer();
        topUri.append(UriFormatUtil.formatYypUri((String)top1.getUri(), (boolean)false));
        logger.info("topUri={} \n  invokeList={}", (Object)topUri, alarmMsg.getUriList());
        if (alarmMsg instanceof RpcAlarm) {
            RpcAlarm alarm = (RpcAlarm)alarmMsg;
            topUri.append("(").append(top1.getRpcHost()).append("(").append(alarm.getRpcSrvName()).append(")").append(")");
        }
        return topUri.toString();
    }

    public static String getRpcProcInfo(AlarmMsg alarmMsg) {
        StringBuffer rpcHost = new StringBuffer();
        if (alarmMsg instanceof RpcAlarm) {
            RpcAlarm alarm = (RpcAlarm)alarmMsg;
            rpcHost.append(alarm.getRpcHost()).append("(").append(alarm.getRpcSrvName()).append(")");
        }
        return rpcHost.toString();
    }

    private String buildReduceKey(AlarmMsgProcNode msgTreeNode, String analysisType) {
        String errorTag = analysisType + "-" + msgTreeNode.getAlarmMsg().getErrorType();
        String reduceKey = "aomi:" + msgTreeNode.getApp().getClientname() + "-" + errorTag;
        logger.info("buildReduceKey={}", (Object)reduceKey);
        return reduceKey;
    }

    private String getAnalysisProcessName() {
        ProcessInfoCollector collector = AomiSdk.getProcessInfoCollector();
        String procName = "";
        if (collector != null) {
            procName = collector.getInfo().getProcessname();
        }
        return procName;
    }
}

