/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.quartz;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@EnableScheduling
public class WorkScheduler
implements SchedulerFactoryBeanCustomizer {
    private static Logger log = LoggerFactory.getLogger(WorkScheduler.class);
    private static ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
    private static int jobKey = 0;
    public static final String JOB_PARAM = "jobParam";
    @Autowired
    private Scheduler sched;

    @PostConstruct
    private void init() {
        try {
            this.sched.clear();
        }
        catch (SchedulerException e) {
            log.error("", (Throwable)e);
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return scheduledThreadPool;
    }

    public void executeCronSchedule(Class<? extends Job> jobClass, String cronExpresstion) {
        this.executeCronSchedule(jobClass, cronExpresstion, null);
    }

    public void executeCronSchedule(Class<? extends Job> jobClass, String cronExpresstion, Map<String, Object> paramMap) {
        int _jobKey = jobKey++;
        try {
            JobDetail job = JobBuilder.newJob(jobClass).withIdentity("job" + _jobKey, "group" + _jobKey).build();
            JobDataMap map = new JobDataMap();
            map.put("jobClass", jobClass);
            if (paramMap != null) {
                map.put(JOB_PARAM, paramMap);
            }
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger" + _jobKey, "group" + _jobKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpresstion)).usingJobData(map).build();
            Date ft = this.sched.scheduleJob(job, (Trigger)trigger);
            log.info(job.getKey() + " has been scheduled to run at: " + ft + " and repeat based on expression: " + trigger.getCronExpression());
        }
        catch (SchedulerException e) {
            log.error("WorkScheduler error.", (Throwable)e);
        }
    }

    public void customize(SchedulerFactoryBean schedulerFactoryBean) {
        schedulerFactoryBean.setStartupDelay(2);
        schedulerFactoryBean.setAutoStartup(true);
        schedulerFactoryBean.setOverwriteExistingJobs(true);
    }
}

