/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.analysis;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.common.model.proto.Header;
import com.yy.aomi.common.model.proto.ProcMonInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class MonitorAppInfo
extends Header {
    public List<String> ipList;
    public List<Integer> portList;
    private ProcMonInfo procInfo;
    @JSONField(serialize=false)
    private String serviceHostId;

    public MonitorAppInfo() {
    }

    public MonitorAppInfo(String clientname, String pid, String srvid, String groupid, long time, long reportTime) {
        this.clientname = clientname;
        this.pid = pid;
        this.srvid = srvid;
        this.groupid = groupid;
        this.time = time;
        this.reportTime = reportTime;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getReportTime() {
        if (this.reportTime == 0L) {
            this.reportTime = this.time;
        }
        return this.reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public String getClientname() {
        return this.clientname;
    }

    public void setClientname(String clientname) {
        this.clientname = clientname;
    }

    public List<String> getIpList() {
        return this.ipList;
    }

    public void setIpList(List<String> ips) {
        if (ips == null) {
            ips = new ArrayList<String>(1);
        } else {
            Collections.sort(ips);
        }
        this.ipList = ips;
    }

    public List<Integer> getPortList() {
        return this.portList;
    }

    public void setPortList(List<Integer> ports) {
        if (ports == null) {
            ports = new ArrayList<Integer>(1);
        } else {
            Collections.sort(ports);
        }
        this.portList = ports;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getSrvid() {
        return this.srvid;
    }

    public void setSrvid(String srvid) {
        this.srvid = srvid;
    }

    public String getGroupid() {
        return this.groupid;
    }

    public void setGroupid(String groupid) {
        this.groupid = groupid;
    }

    public String getBusinessid() {
        return this.businessid;
    }

    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }

    public ProcMonInfo getProcInfo() {
        return this.procInfo;
    }

    public void setProcInfo(ProcMonInfo procMonInfo) {
        this.procInfo = procMonInfo;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JSONField(serialize=false)
    public String getServiceHostId() {
        if (this.serviceHostId == null) {
            this.serviceHostId = this.clientname + ":" + this.defaultIp() + ":" + this.defaultPort();
        }
        return this.serviceHostId;
    }

    public String defaultHost() {
        return this.defaultIp() + ":" + this.defaultPort();
    }

    public int defaultPort() {
        if (!CollectionUtils.isEmpty(this.portList)) {
            return this.portList.get(0);
        }
        return 0;
    }

    public String defaultIp() {
        if (!CollectionUtils.isEmpty(this.ipList)) {
            return this.ipList.get(0);
        }
        return null;
    }

    public MonitorAppInfo copyAppInfoByHost(String ip, int port) {
        MonitorAppInfo appInfo = new MonitorAppInfo(this.clientname, this.pid, this.srvid, this.groupid, this.time, this.reportTime);
        ArrayList<String> ips = new ArrayList<String>(1);
        ArrayList<Integer> ports = new ArrayList<Integer>(1);
        ips.add(ip);
        ports.add(port);
        appInfo.portList = ports;
        appInfo.ipList = ips;
        appInfo.procInfo = this.copyProcMonInfo();
        appInfo.businessid = this.businessid;
        appInfo.source = this.source;
        return appInfo;
    }

    public MonitorAppInfo copyAppInfoByHost() {
        MonitorAppInfo appInfo = new MonitorAppInfo(this.clientname, this.pid, this.srvid, this.groupid, this.time, this.reportTime);
        ArrayList<String> ips = new ArrayList<String>();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (this.ipList != null) {
            ips.addAll(this.ipList);
        }
        if (this.portList != null) {
            ports.addAll(this.portList);
        }
        appInfo.portList = ports;
        appInfo.ipList = ips;
        appInfo.procInfo = this.copyProcMonInfo();
        appInfo.businessid = this.businessid;
        appInfo.source = this.source;
        return appInfo;
    }

    private ProcMonInfo copyProcMonInfo() {
        if (this.procInfo != null) {
            ProcMonInfo proc = new ProcMonInfo(this.procInfo.getSystemMemSize(), this.procInfo.getSystemCpuSize(), this.procInfo.getProcessMemSize());
            proc.setProcessCpuUsage(this.procInfo.getProcessCpuUsage());
            proc.setSystemCpuUsage(this.procInfo.getSystemCpuUsage());
            proc.setProcessMemUsage(this.procInfo.getProcessMemUsage());
            proc.setSystemMemUsage(this.procInfo.getSystemMemUsage());
            return proc;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MonitorAppInfo appInfo = (MonitorAppInfo)((Object)o);
        if (this.clientname != null ? !this.clientname.equals(appInfo.clientname) : appInfo.clientname != null) {
            return false;
        }
        if (!this.hostsPartEq(this.ipList, appInfo.ipList)) {
            return false;
        }
        return this.hostsPartEq(this.portList, appInfo.portList);
    }

    private boolean hostsPartEq(List<?> hostsPart, List<?> thatHostsPart) {
        if (hostsPart == thatHostsPart) {
            return true;
        }
        if (hostsPart != null) {
            if (thatHostsPart == null) {
                return false;
            }
            if (!thatHostsPart.isEmpty() && !hostsPart.isEmpty()) {
                return hostsPart.get(0).equals(thatHostsPart.get(0));
            }
            return hostsPart.size() == thatHostsPart.size();
        }
        return thatHostsPart == null;
    }

    public int hashCode() {
        int result = this.clientname != null ? this.clientname.hashCode() : 0;
        result = 31 * result + (this.ipList != null && this.ipList.size() > 0 ? this.ipList.get(0).hashCode() : 0);
        result = 31 * result + (this.portList != null && this.portList.size() > 0 ? this.portList.get(0).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MonitorAppInfo{clientname='" + this.clientname + '\'' + ", groupid='" + this.groupid + '\'' + ", srvid='" + this.srvid + '\'' + ", businessid='" + this.businessid + '\'' + ", pid='" + this.pid + '\'' + ", source='" + this.source + '\'' + ", ipList=" + this.ipList + ", portList=" + this.portList + ", time=" + this.time + ", reportTime=" + this.reportTime + ", procInfo=" + this.procInfo + ", serviceHostId='" + this.serviceHostId + '\'' + '}';
    }
}

