/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.analysis;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.analysis.UriAnalysisData;
import com.yy.aomi.common.model.proto.ModelContext;
import com.yy.aomi.common.model.proto.RpcContext;
import com.yy.aomi.common.model.proto.ThreadPoolContext;
import java.util.ArrayList;
import java.util.List;

public class ModelAnalysisData {
    private int modelType;
    private String modelId;
    private ModelContext context;
    private List<UriAnalysisData> uriNodes;
    private AlarmMsg summaryAlarm;

    public ModelAnalysisData() {
    }

    public ModelAnalysisData(int modelType, String modelId, ModelContext context) {
        this.modelType = modelType;
        this.modelId = modelId;
        this.context = context;
    }

    public void addUriData(UriAnalysisData uriAnalysisData) {
        if (this.uriNodes == null) {
            this.uriNodes = new ArrayList<UriAnalysisData>();
        }
        this.uriNodes.add(uriAnalysisData);
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public List<UriAnalysisData> getUriNodes() {
        return this.uriNodes;
    }

    public void setUriNodes(List<UriAnalysisData> uriNodes) {
        this.uriNodes = uriNodes;
    }

    public ModelContext getContext() {
        return this.context;
    }

    public void setContext(ModelContext context) {
        this.context = context;
    }

    public AlarmMsg getSummaryAlarm() {
        return this.summaryAlarm;
    }

    public void setSummaryAlarm(AlarmMsg summaryAlarm) {
        this.summaryAlarm = summaryAlarm;
    }

    public static ModelAnalysisData instance(int modelType, String modelId, JSONObject ctx) {
        ModelContext context = null;
        switch (modelType) {
            case 2: {
                context = (ModelContext)ctx.toJavaObject(RpcContext.class);
                break;
            }
            case 1: {
                context = (ModelContext)ctx.toJavaObject(ThreadPoolContext.class);
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
        }
        return new ModelAnalysisData(modelType, modelId, context);
    }

    public String toString() {
        return "ModelAnalysisData{modelType=" + this.modelType + ", modelId='" + this.modelId + '\'' + ", context=" + this.context + ", uriNodes=" + this.uriNodes + ", summaryAlarm=" + this.summaryAlarm + '}';
    }
}

