/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

public class UriInvokeInfo {
    private String uri;
    private long count;
    private long avgTime;
    private long errorCount;
    private long totalTime;
    private long thProcTl;
    public double percent;
    protected double threadUseRate;
    private String rpcHost;

    public UriInvokeInfo() {
    }

    public UriInvokeInfo(String uri, long count, long errorCount, long totalTime, long thProcTl, String rpcHost) {
        this(uri, count, errorCount, totalTime, thProcTl);
        this.rpcHost = rpcHost;
    }

    public UriInvokeInfo(String uri, long count, long errorCount, long totalTime, long thProcTl) {
        this.uri = uri;
        this.count = count;
        this.errorCount = errorCount;
        this.totalTime = totalTime;
        this.avgTime = count == 0L ? 0L : totalTime / count;
        this.percent = this.getPercent();
        this.thProcTl = thProcTl;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getAvgTime() {
        return this.avgTime;
    }

    public void setAvgTime(long avgTime) {
        this.avgTime = avgTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public double getPercent() {
        if (this.count > 0L) {
            this.percent = Double.parseDouble(String.format("%.2f", (double)(this.errorCount * 100L) / ((double)this.count * 1.0)));
        }
        return this.percent;
    }

    public double getThreadUseRate() {
        return this.threadUseRate;
    }

    public void setThreadUseRate(double threadUseRate) {
        this.threadUseRate = threadUseRate;
    }

    public String getRpcHost() {
        return this.rpcHost;
    }

    public void setRpcHost(String rpcHost) {
        this.rpcHost = rpcHost;
    }

    public long getThProcTl() {
        return this.thProcTl;
    }

    public void setThProcTl(long thProcTl) {
        this.thProcTl = thProcTl;
    }

    public String toString() {
        return "UriInvokeInfo{uri='" + this.uri + '\'' + ", count=" + this.count + ", avgTime=" + this.avgTime + ", errorCount=" + this.errorCount + ", totalTime=" + this.totalTime + ", thProcTl=" + this.thProcTl + ", percent=" + this.percent + ", threadUseRate=" + this.threadUseRate + ", rpcHost='" + this.rpcHost + '\'' + '}';
    }
}

