/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.JSONObject;
import com.yy.aomi.analysis.common.model.alarm.ErrorChainNode;
import com.yy.aomi.analysis.common.util.tree.TreeNode;
import org.springframework.format.annotation.DateTimeFormat;

public class EventAnalysis {
    private Long id;
    private String type;
    private Integer level;
    private Integer analyseType;
    private int rootCause;
    private String url;
    private String data;
    private String treeId;
    private String appId;
    private String serviceName;
    private String groupId;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected long createTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private long beginTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private long endTime;
    private String charge;

    public EventAnalysis() {
    }

    public EventAnalysis(TreeNode<ErrorChainNode> treeNode) {
        ErrorChainNode msgNode = treeNode.getMsgNode();
        this.treeId = treeNode.getTreeId();
        if (treeNode.getParentId() == -1) {
            this.rootCause = 1;
        }
        this.serviceName = msgNode.getAppName();
        this.analyseType = msgNode.getAnalyseType();
        this.groupId = msgNode.getBusinessId();
        this.beginTime = msgNode.getBeginTime();
        this.endTime = msgNode.getEndTime();
        this.data = JSONObject.toJSONString(treeNode);
        this.charge = msgNode.getCharge();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getAnalyseType() {
        return this.analyseType;
    }

    public void setAnalyseType(Integer analyseType) {
        this.analyseType = analyseType;
    }

    public int getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(int rootCause) {
        this.rootCause = rootCause;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public String toString() {
        return "EventAnalysis{, type='" + this.type + '\'' + ", level=" + this.level + ", analyseType=" + this.analyseType + ", rootCause=" + this.rootCause + ", url='" + this.url + '\'' + ", data='" + this.data + '\'' + ", treeId='" + this.treeId + '\'' + ", appId='" + this.appId + '\'' + ", serviceName='" + this.serviceName + '\'' + ", groupId='" + this.groupId + '\'' + ", createTime=" + this.createTime + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + '}';
    }
}

