/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.alibaba.fastjson.annotation.JSONField;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsg;
import com.yy.aomi.analysis.common.model.analysis.MonitorAppInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class AlarmMsgTreeNode {
    private String treeId;
    private String msg;
    @JSONField(serialize=false)
    private int analyseType;
    private String summary;
    private String processor;
    private List<AlarmMsgTreeNode> children;
    @JSONField(serialize=false)
    private String errorType;
    @JSONField(serialize=false)
    public AlarmMsg alarmMsg;
    @JSONField(serialize=false)
    public MonitorAppInfo app;

    public AlarmMsgTreeNode(AlarmMsg alarmMsg) {
        if (alarmMsg.getApp() != null) {
            this.processor = alarmMsg.getApp().getServiceHostId();
        }
        this.treeId = alarmMsg.getTreeId();
        this.alarmMsg = alarmMsg;
        this.app = alarmMsg.getApp();
    }

    public void addChild(AlarmMsgTreeNode node) {
        if (this.children == null) {
            this.children = new ArrayList<AlarmMsgTreeNode>();
        }
        this.children.add(node);
    }

    public void addChildren(List<AlarmMsgTreeNode> nodes) {
        if (this.children == null) {
            this.children = new ArrayList<AlarmMsgTreeNode>();
        }
        this.children.addAll(nodes);
    }

    public AlarmMsgTreeNode searchTreeLastChild() {
        AlarmMsgTreeNode next;
        AlarmMsgTreeNode alarmMsg = null;
        if (this.hasChildren() && (next = (alarmMsg = this.children.get(this.children.size() - 1)).searchTreeLastChild()) == null) {
            return alarmMsg;
        }
        return alarmMsg;
    }

    public int getAnalyseType() {
        return this.analyseType;
    }

    public void setAnalyseType(int analyseType) {
        this.analyseType = analyseType;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public List<AlarmMsgTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<AlarmMsgTreeNode> children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return !CollectionUtils.isEmpty(this.children);
    }

    public MonitorAppInfo getApp() {
        return this.app;
    }

    public void setApp(MonitorAppInfo app) {
        this.app = app;
    }

    public AlarmMsg getAlarmMsg() {
        return this.alarmMsg;
    }

    public void setAlarmMsg(AlarmMsg alarmMsg) {
        this.alarmMsg = alarmMsg;
    }

    public void getAllTreeIds(Set<String> ids) {
        if (this.treeId != null && !this.treeId.isEmpty()) {
            ids.add(this.treeId);
        }
        if (this.hasChildren()) {
            for (AlarmMsgTreeNode child : this.children) {
                child.getAllTreeIds(ids);
            }
        }
    }

    public String toString() {
        return "AlarmMsgTreeNode{, msg='" + this.msg + '\'' + ", summary='" + this.summary + '\'' + ", processor='" + this.processor + '\'' + ", errorType='" + this.errorType + '\'' + ", alarmMsg=" + this.alarmMsg + ", app=" + (Object)((Object)this.app) + ", children=" + this.children + '}';
    }
}

