/*
 * Decompiled with CFR 0.152.
 */
package com.yy.aomi.analysis.common.model.alarm;

import com.yy.aomi.analysis.common.constant.ErrorDefinition;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgNodeChain;
import com.yy.aomi.analysis.common.model.alarm.AlarmMsgProcNode;
import java.util.ArrayList;
import java.util.List;

public class AlarmMsgNodeTree {
    private String treeId;
    private int analyseType;
    private AlarmMsgProcNode root;
    private List<AlarmMsgNodeChain> children = new ArrayList<AlarmMsgNodeChain>(1);

    public List<AlarmMsgNodeChain> getChildren() {
        return this.children;
    }

    public void setChildren(List<AlarmMsgNodeChain> children) {
        this.children = children;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public AlarmMsgProcNode getRoot() {
        return this.root;
    }

    public void setRoot(AlarmMsgProcNode root) {
        this.root = root;
    }

    public int calProcCount() {
        int count = 1;
        for (AlarmMsgNodeChain chain : this.children) {
            count += chain.size();
        }
        return count;
    }

    public int calErrorCount() {
        int count = 1;
        for (AlarmMsgNodeChain chain : this.children) {
            for (AlarmMsgProcNode node : chain) {
                if (!ErrorDefinition.isError(node.getAlarmMsg().getErrorType())) continue;
                ++count;
            }
        }
        return count;
    }

    public int getAnalyseType() {
        return this.analyseType;
    }

    public void setAnalyseType(int analyseType) {
        this.analyseType = analyseType;
    }
}

